<?php

/**
 * Controller for handling the users section and actions on users in the
 * admin control panel.
 *
 * @package UserEss
 */
class UserEss_ControllerAdmin_User extends XFCP_UserEss_ControllerAdmin_User
{
	/**
	 * Inserts a new user or updates an existing one.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionSave()
	{
		$this->_assertPostOnly();
		$userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
		
		if ($userId)
		{
			$user = $this->_getUserOrError($userId);
			$newName = $this->_input->filterSingle('username', XenForo_Input::STRING);
			$newName = trim(preg_replace('/\s+/', ' ', $newName)); // standardize white space in names
			
			// name change
			if (!empty($newName) && $user['username'] != $newName)
			{
				$response = parent::actionSave(); // ensure all was OK
				
				// add to unc table
				$writer = XenForo_DataWriter::create('UserEss_DataWriter_UNC');
				$writer->setOption(UserEss_DataWriter_UNC::OPTION_SET_IP_ADDRESS, false);
				
				$vars = array(
					'user_id' => $userId,
					'from_username' => $user['username'],
					'to_username' => $newName,
					'date' => XenForo_Application::$time,
					'via_acp' => 1
				);
				
				$writer->bulkSet($vars);
				$writer->save();
				
				return $response;
			}
		}
		
		return parent::actionSave();
	}
	
	protected function _getUserAddEditResponse(array $user)
	{
		$response = parent::_getUserAddEditResponse($user);
		
		if (!empty($response->params))
		{
			$previousNames = $this->_getUNCModel()->getUNCByUserId($user['user_id'], array('status' => 'approved'));
			
			if (!empty($previousNames))
			{
				$response->params['previousNames'] = $previousNames;
				$response->params['previousNamesCount'] = count($previousNames);
			}
		}
		
		return $response;
	}
	
	/**
	 * @return UserEss_Model_UNC
	 */
	protected function _getUNCModel()
	{
		return $this->getModelFromCache('UserEss_Model_UNC');
	}
}