<?php

class UserEss_ControllerAdmin_UserLog extends XenForo_ControllerAdmin_Log
{
	public function actionIndex()
	{
		$this->assertAdminPermission('viewLogs');
		$logModel = $this->_getUserLogModel();
		
		$id = $this->_input->filterSingle('id', XenForo_Input::UINT);
		if ($id)
		{
			$entry = $logModel->getUserLogById($id);
			if (!$entry)
			{
				return $this->responseError(new XenForo_Phrase('requested_log_entry_not_found'), 404);
			}
			
			$viewParams = array(
				'entry' => $logModel->prepareUserLogEntry($entry),
				'user_log_id' => $id
			);
			return $this->responseView('XenForo_ViewAdmin_Log_ModeratorView', 'useress_log_user_view', $viewParams);
		}
		else
		{
			$userId = 0;
			$username = $this->_input->filterSingle('username', XenForo_Input::STRING);
			if (!empty($username))
			{
				$user = $this->_getUserModel()->getUserByName($username);
				if (!empty($user))
					$userId = $user['user_id'];
			}
			$page = $this->_input->filterSingle('page', XenForo_Input::UINT);
			$perPage = 20;
			
			$pageParams = array();
			if ($userId)
			{
				$pageParams['user_id'] = $userId;
			}
			
			$action = $this->_input->filterSingle('action', XenForo_Input::STRING);
			
			$fetchOptions = array(
					'page' => $page,
					'perPage' => $perPage
			);
			
			if ($userId)
				$fetchOptions['userId'] = $userId;
			else if (!empty($username))
				$fetchOptions['username'] = $username;
			
			if (!empty($action))
				$fetchOptions['action'] = $action;
			
			$entries = $logModel->getUserLogEntries($fetchOptions);
			
			$viewParams = array(
				'entries' => $logModel->prepareUserLogEntries($entries),
				'total' => $logModel->countUserLogEntries($fetchOptions),
				'page' => $page,
				'perPage' => $perPage,
				'pageParams' => $pageParams,
				'userId' => $userId,
				'logUsername' => $username,
				'action' => $action
			);
			
			return $this->responseView('XenForo_ViewAdmin_Log_Moderator', 'useress_log_user', $viewParams);
		}
	}
	
	public function actionClear()
	{
		$this->assertAdminPermission('viewLogs');
		
		if ($this->isConfirmedPost())
		{
			$this->_getUserLogModel()->clearLog();
			
			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildAdminLink('user-log')
			);
		}
		else
		{
			$viewParams = array();
			return $this->responseView('XenForo_ViewAdmin_Log_ServerErrorDelete', 'useress_log_clear', $viewParams);
		}		
	}
	
	/**
	 * @return XenForo_Model_User
	 */
	protected function _getUserModel()
	{
		return $this->getModelFromCache('XenForo_Model_User');
	}
	
	/**
	 * @return UserEss_Model_Log
	 */
	protected function _getUserLogModel()
	{
		return $this->getModelFromCache('UserEss_Model_UserLog');
	}
}