<?php

/**
 * Controller for forum-related actions.
 *
 * @package UserEss
 */
class UserEss_ControllerPublic_Forum extends XFCP_UserEss_ControllerPublic_Forum
{
	/**
	 * Displays a form to create a new thread in this forum.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionCreateThread()
	{
		$response = parent::actionCreateThread();
		
		if (!empty($response) && isset($response->params))
		{
			if (isset($response->params['forum']['node_id']))
			{
				$response->params['canCreatePoll'] = $this->_getForumModel()->canCreatePoll($response->params['forum']['node_id']);
			}
		}
		
		return $response;
	}
}
