<?php

/**
 * Controller for displaying user name changes
 *
 * @package UserEss
 */
class UserEss_ControllerPublic_Member extends XFCP_UserEss_ControllerPublic_Member
{
	/**
	 * Member profile page
	 * Name Changes tab
	 *
	 * @return XenForo_ControllerResponse_View / XenForo_ControllerResponse_Redirect
	 */
	public function actionNameChanges()
	{
		$userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
		$member = $this->getHelper('UserProfile')->assertUserProfileValidAndViewable($userId);
		$memberId = $member['user_id'];
		$displayProfileTab = XenForo_Application::get('options')->useressDisplayProfileTab;
		$visitor = XenForo_Visitor::getInstance();
		$doDisplay = false;
		
		if ($displayProfileTab == 'everybody')
		{
			$doDisplay = true;
		}
		else
		{
			if ($displayProfileTab == 'members' && $visitor['user_id'] > 0)
			{
				$doDisplay = true;
			}
			else if ($displayProfileTab == 'mods' || $displayProfileTab == 'mods_and_member')
			{
				if ($displayProfileTab == 'mods_and_member' && $visitor['user_id'] == $memberId)
				{
					$doDisplay = true;
				}
				else if ($visitor['is_admin'] || $visitor['is_moderator'] )
				{
					$doDisplay = true;
				}
			}
		}
		
		// visitor can view name changes
		if ($doDisplay)
		{
			$conditions = array();
			
			// do we count name changes made via the ACP?
			if (!XenForo_Application::get('options')->uncDisplayChangesViaACP)
				$conditions['skip_acp'] = 1;
			
			$conditions['status'] = 'approved';
			
			// moderation is on so fetch status if necessary
			if (XenForo_Application::get('options')->uncModerate)
			{
				if (($visitor['is_moderator'] || $visitor['is_admin']) || ($visitor['user_id'] == $memberId))
				{
					unset($conditions['status']); // fetch all
				}
			}
			
			$previousNames = $this->_getUNCModel()->getUNCByUserId($memberId, $conditions);
			
			$viewParams = array(
					'user' => $member,
					'previousNames' => $previousNames,
					'displayStatus' => empty($limitToStatus) ? true : false
			);
			
			return $this->responseView('XenForo_ViewPublic_Base', 'useress_member_name_changes', $viewParams);
		}
		else // go back
		{
			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::RESOURCE_CANONICAL,
				XenForo_Link::buildPublicLink('members', $member)
			);
		}
	}
	
	/**
	 * View the User Name Change details via the member profile page
	 *
	 * @return XenForo_ControllerResponse_View
	 */
	public function actionViewUNC()
	{
		$userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
		$user = $this->getHelper('UserProfile')->getUserOrError($userId);
		$uncId = $this->_input->filterSingle('unc_id', XenForo_Input::UINT);
		$visitor = XenForo_Visitor::getInstance();
		
		if (!$visitor['is_moderator'] && !$visitor['is_admin'])
		{
			return $this->responseNoPermission();
		}
		
		$unc = $this->_getUNCModel()->getUNCById($uncId);
		If (empty($unc))
		{
			return $this->responseError(new XenForo_Phrase('useress_unc_not_found'), 404);
		}
		
		if (!empty($unc['moderator_id']))
		{
			$moderator = $this->_getUserModel()->getUserById($unc['moderator_id']);
			if (empty($moderator))
			{
				$moderator = array('user_id' => 0, 'username' => new XenForo_Phrase('n_a'));
			}
			else
			{
				$moderator = array('user_id' => $moderator['user_id'], 'username' => $moderator['username']);
			}
		}
		else
		{
			$moderator = array();
		}
		
		$viewParams = array(
			'user' => array('user_id' => $user['user_id'], 'username' => $user['username']),
			'moderator' => $moderator,
			'unc' => $unc
		);
		
		return $this->responseView('XenForo_ViewPublic_Base', 'useress_unc_view', $viewParams);	
	}
	
	/**
	 * @return UserEss_Model_UNC
	 */
	protected function _getUNCModel()
	{
		return $this->getModelFromCache('UserEss_Model_UNC');
	}
}
