<?php

/**
 * Controller for post-related actions.
 *
 * @package UserEss
 */
class UserEss_ControllerPublic_Post extends XFCP_UserEss_ControllerPublic_Post
{
	/**
	 * Displays a form to edit an existing post.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionEdit()
	{
		$response = parent::actionEdit();
		
		$postPosition = $response->params['post']['position'];
		$postModel = $this->_getPostModel();
		$post = $response->params['post'];
		$thread = $response->params['thread'];
		$forum = $response->params['forum'];
		
		$viewingUser = XenForo_Visitor::getInstance();
		$nodePermissions = $viewingUser->getNodePermissions($thread['node_id']);
		$viewingUser = $viewingUser->toArray();
					
		// only display the thread title edit on first post edit
		if ($post['post_id'] == $thread['first_post_id'])
		{
			$threadModel = $this->_getThreadModel();
			$errorPhraseKey = '';
			
			// edit title permission is set
			if ($threadModel->canEditThreadTitle($thread, $forum, $errorPhraseKey, $nodePermissions, $viewingUser))
			{
				$response->params['canEditOwnThreadTitle'] = true;
				$response->params['prefixes'] = $this->_getPrefixModel()->getUsablePrefixesInForums($forum['node_id']);
			}
			
			// edit thread status permission - lock/unlock
			if ($threadModel->canLockUnlockThread($thread, $forum, $errorPhraseKey, $nodePermissions, $viewingUser))
			{
				$response->params['canLockUnlockOwnThread'] = true;
			}
		}
		
		return $response;
	}
	
	/**
	 * Updates an existing post.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionSave()
	{
		$this->_assertPostOnly();
				
		// grab current post before new save as we need the old message
		$postId = $this->_input->filterSingle('post_id', XenForo_Input::UINT);
		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($post, $thread, $forum) = $ftpHelper->assertPostValidAndViewable($postId);
		
		$redirect = parent::actionSave(); // ensure all was OK - such as message length
		if (!empty($redirect))
		{
			// first post
			if ($post['post_id'] == $thread['first_post_id'])
			{
				$writer = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
				$writer->setExistingData($thread['thread_id']);
				$actionArray = array();
				$postModel = $this->_getPostModel();
				$threadModel = $this->_getThreadModel();
				$errorPhraseKey = '';
				
				// thread lock/unlock
				$threadOpen = $this->_input->filterSingle('discussion_open', XenForo_Input::UINT);
				if ($threadOpen != $thread['discussion_open'])
				{
					// permission is set
					if ($threadModel->canLockUnlockThread($thread, $forum, $errorPhraseKey))
					{
						$writer->set('discussion_open', $threadOpen);
						if ($threadOpen)
							$actionArray['unlock'] = $threadOpen;
						else
							$actionArray['lock'] = $threadOpen;
					}
				}
									
				// thread title
				$threadTitle = $this->_input->filterSingle('title', XenForo_Input::STRING);
				
				// thread prefix
				$threadPrefixId = $this->_input->filterSingle('prefix_id', XenForo_Input::UINT);
				

				if ($threadTitle || $threadPrefixId)
				{
					$oldThreadTitle = $thread['title'];
					$oldThreadPrefixId = $thread['prefix_id'];
					
					if ($threadPrefixId)
					{
						if (!$this->_getPrefixModel()->verifyPrefixIsUsable($threadPrefixId, $forum['node_id']))
						{
							$threadPrefixId = 0; // not usable, just blank it out
						}
					}
					
					// title or prefix has changed
					if ($threadTitle != $oldThreadTitle || $threadPrefixId != $oldThreadPrefixId)
					{
						// permission is set
						if ($threadModel->canEditThreadTitle($thread, $forum))
						{
							if ($threadTitle != $oldThreadTitle)
							{
								$writer->set('title', $threadTitle);
								$actionArray['title'] = $oldThreadTitle;
								$thread['title'] = $threadTitle; // use new title
							}
								
							if ($threadPrefixId != $oldThreadPrefixId)
							{
								$writer->set('prefix_id', $threadPrefixId);
								
								if ($oldThreadPrefixId)
								{
									$phrase = new XenForo_Phrase('thread_prefix_' . $oldThreadPrefixId);
									$oldValue = $phrase->render();
								}
								else
									$oldValue = new XenForo_Phrase('no_prefix');
								
								if ($threadPrefixId)
								{
									$phrase = new XenForo_Phrase('thread_prefix_' . $threadPrefixId);
									$newValue = $phrase->render();
								}
								else
									$newValue = new XenForo_Phrase('no_prefix');
								
								$actionArray['prefix'] = $oldValue . '\' ' . new XenForo_Phrase('useress_to') . ' \'' . $newValue;
							}
						}
					}
				}
				
				if ($writer->hasChanges())
					$writer->save();
					
				if (!empty($actionArray))
				{
					$visitor = XenForo_Visitor::getInstance()->toArray();
					
					// log the action
					if ($post['user_id'] == $visitor['user_id']) // thread creator
					{						
						foreach ($actionArray AS $action => $oldValue)
						{
							UserEss_Model_UserLog::logUserAction(
								'thread', $thread, $action, array('old' => $oldValue), $forum, $visitor
							);
						}					
					}
					else if ($visitor['is_moderator']) // moderator
					{
						foreach ($actionArray AS $action => $oldValue)
						{
							XenForo_Model_Log::logModeratorAction(
								'thread', $thread, $action, array('old' => $oldValue), $forum, $visitor
							);
						}
					}
				}
			}
		}
		
		return $redirect;
	}
	
	/**
	 * @return XenForo_Model_Thread
	 */
	protected function _getThreadModel()
	{
		return $this->getModelFromCache('XenForo_Model_Thread');
	}
	
	/**
	 * @return XenForo_Model_ThreadPrefix
	 */
	protected function _getPrefixModel()
	{
		return $this->getModelFromCache('XenForo_Model_ThreadPrefix');
	}
}
