<?php

/**
 * Controller for registration-related actions.
 *
 * @package UserEss
 */
class UserEss_ControllerPublic_Register extends XFCP_UserEss_ControllerPublic_Register
{
	/**
	 * Validate a single field
	 *
	 * @return XenForo_ControllerResponse_Redirect
	 */
	public function actionValidateField()
	{
		$this->_assertPostOnly();

		// check whether this username was previously used by any other member
		if (!XenForo_Application::get('options')->uncAllowPreviousNames)
		{
			$uncModel = $this->_getUNCModel();
			$data = $this->_getFieldValidationInputParams();
			
			if ($uncModel->doesUNCNameExists($data['value']))
			{
				$writer = XenForo_DataWriter::create('XenForo_DataWriter_User');
				$writer->error(new XenForo_Phrase('useress_unc_name_previously_used'), 'username', false);
				
				if ($errors = $writer->getErrors())
				{
					return $this->responseError($errors);
				}
			}
		}
		
		return parent::actionValidateField();
	}
	
	/**
	 * Registers a new user.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionRegister()
	{
		$this->_assertPostOnly();
		$this->_assertRegistrationActive();
		
		// check whether this username was previously used by any other member
		if (!XenForo_Application::get('options')->uncAllowPreviousNames)
		{
			$uncModel = $this->_getUNCModel();
			$username = $this->_input->filterSingle('username', XenForo_Input::STRING);
			
			if ($uncModel->doesUNCNameExists($username))
			{
				$writer = XenForo_DataWriter::create('XenForo_DataWriter_User');
				$writer->error(new XenForo_Phrase('useress_unc_name_previously_used'), 'username', false);
				
				if ($errors = $writer->getErrors())
				{
					return $this->_getRegisterFormResponse(array('username' => $username), $errors);
				}
			}
		}
		
		return parent::actionRegister();		
	}
	
	/**
	 * @return UserEss_Model_UNC
	 */
	protected function _getUNCModel()
	{
		return $this->getModelFromCache('UserEss_Model_UNC');
	}
}
