<?php

/**
 * Controller for thread-related actions.
 *
 * @package UserEss
 */
class UserEss_ControllerPublic_Thread extends XFCP_UserEss_ControllerPublic_Thread
{
	/**
	 * Logs the moderator actions for thread edits.
	 *
	 * @param array $thread
	 * @param XenForo_DataWriter_Discussion_Thread $dw
	 * @param array $skip Array of keys to skip logging for
	 */
	protected function _updateModeratorLogThreadEdit(array $thread, XenForo_DataWriter_Discussion_Thread $dw, array $skip = array())
	{
		parent::_updateModeratorLogThreadEdit($thread, $dw, $skip);
		
		// USER LOG
		$visitor = XenForo_Visitor::getInstance()->toArray();
		if (!$visitor['is_moderator'] && $thread['user_id'] == $visitor['user_id'])
		{
			$newData = $dw->getMergedNewData();
			if ($newData)
			{
				$thread = $dw->getMergedData();
				$oldData = $dw->getMergedExistingData();

				foreach ($newData AS $key => $value)
				{
					$oldValue = (isset($oldData[$key]) ? $oldData[$key] : '');
					switch ($key)
					{
						case 'sticky':
						{
							UserEss_Model_UserLog::logUserAction(
								'thread', $thread, ($value ? 'stick' : 'unstick'), array(), null, $visitor)
							;
							break;
						}
						case 'discussion_open':
						{
							UserEss_Model_UserLog::logUserAction(
								'thread', $thread, ($value ? 'unlock' : 'lock'), array(), null, $visitor)
							;
							break;
						}
						case 'title':
						{
							UserEss_Model_UserLog::logUserAction(
								'thread', $thread, 'title', array('old' => $oldValue), null, $visitor)
							;
							break;
						}
						case 'prefix_id':
						{
							if ($oldValue)
							{
								$phrase = new XenForo_Phrase('thread_prefix_' . $oldValue);
								$oldValue = $phrase->render();
							}
							else
							{
								$oldValue = new XenForo_Phrase('no_prefix');
							}
							
							$newValue = (isset($newData[$key]) ? $newData[$key] : '');
							if ($newValue)
							{
								$phrase = new XenForo_Phrase('thread_prefix_' . $newValue);
								$newValue = $phrase->render();
							}
							else
								$newValue = new XenForo_Phrase('no_prefix');
							
							$oldValue = $oldValue . '\' ' . new XenForo_Phrase('useress_to') . ' \'' . $newValue;
							
							UserEss_Model_UserLog::logUserAction(
								'thread', $thread, 'prefix', array('old' => $oldValue), null, $visitor)
							;
							break;
						}
					}
				}
			}
		}		
	}
	
	/**
	 * Adds a poll to this thread.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionPollAdd()
	{
		$response = parent::actionPollAdd();
		
		if ($response instanceof XenForo_ControllerResponse_Redirect && $this->_request->isPost())
		{
			$threadId = $this->_input->filterSingle('thread_id', XenForo_Input::UINT);
			$ftpHelper = $this->getHelper('ForumThreadPost');
			list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($threadId);
			$visitor = XenForo_Visitor::getInstance()->toArray();
			
			// log the action
			if ($thread['user_id'] == $visitor['user_id']) // thread creator
			{
				$pollInput = $this->_input->filterSingle('poll', XenForo_Input::ARRAY_SIMPLE);
								
				UserEss_Model_UserLog::logUserAction(
					'thread', $thread, 'poll', array('old' => $pollInput['question']), $forum, $visitor
				);					
			}
		}
		
		return $response;
	}
}
