<?php

/**
 * Cron entry for cleaning up the user log table.
 *
 * @package UserEss
 */
class UserEss_CronEntry_CleanUp
{
	/**
	 * Clean up the user log
	 */
	public static function cleanUp()
	{
		$options = XenForo_Application::get('options');
		
		// USER LOG
		$userLogLength = $options->useressLogLength;
		if ($userLogLength)
		{
			$pruneDate = XenForo_Application::$time - (86400 * $userLogLength);
			XenForo_Model::create('UserEss_Model_UserLog')->pruneLog($pruneDate);
		}
		
		// REVERT UNC CUSTOM TITLES
		XenForo_Model::create('UserEss_Model_UNC')->uncRevertCustomTitles();
	}
}