<?php

/**
* Data writer for threads.
*
* @package UserEss
*/
class UserEss_DataWriter_Discussion_Thread extends XFCP_UserEss_DataWriter_Discussion_Thread
{
	/**
	 * Specific discussion post-save behaviors.
	 */
	protected function _discussionPostSave()
	{
		parent::_discussionPostSave();
		
		$doDelete = false;
		
		if ($this->isInsert() && !$this->get('discussion_open') && $this->get('discussion_type') != 'redirect')
		{
			$visitor = XenForo_Visitor::getInstance();
			$userId = $this->get('user_id');
			
			if ($visitor['user_id'] && ($visitor['user_id'] == $userId))
			{
				$nodeId = $this->get('node_id');
				
				// not an admin/mod but has the lock own thread permission
				if ($visitor->hasNodePermission($nodeId, 'lockUnlockOwnThread') || $visitor->hasNodePermission($nodeId, 'lockUnlockThread'))
				{
					$thread = array(
						'thread_id' => $this->get('thread_id'),
						'title' => $this->get('title'),
						'user_id' => $userId,
						'username' => $this->get('username')
					);
					
					UserEss_Model_UserLog::logUserAction('thread', $thread, 'lock', array(), null, $visitor->toArray());
				}
			}
		}
		else if ($this->get('discussion_type') != 'redirect')
		{
			// was locked but now is open
			if (!$this->getExisting('discussion_open') && $this->get('discussion_open'))
			{
				$doDelete = true;
			}
			else if ($this->getExisting('discussion_open') && !$this->get('discussion_open')) // was open but now is locked
			{
				$visitor = XenForo_Visitor::getInstance();
				if ($visitor['user_id'] && ($visitor['is_admin'] || $visitor['is_moderator']))
				{
					// save who last locked the thread
					$threadId = $this->get('thread_id');
					$wasLockedByMod = $this->_getThreadModel()->wasLockedByMod($threadId);
					if (!$wasLockedByMod) // must check in case add-on was deactivated at some point and table was populated
					{
						$this->_db->insert('useress_thread_lock', array('thread_id' => $threadId, 'user_id' => $visitor['user_id']));
					}
					else // update as it might be a different user since last time as the add-on was deactivated (only reason for such a situation)
					{
						$threadIdQuoted = $this->_db->quote($threadId);
						$this->_db->update('useress_thread_lock', array('user_id' => $visitor['user_id']), "thread_id = $threadIdQuoted");
					}
				}
			}
		}
		else if ($this->get('discussion_type') == 'redirect' && $this->getExisting('discussion_type') != 'redirect') // was saved as a redirect
		{
			$doDelete = true;
		}
		
		if ($this->isChanged('discussion_state') && $this->get('discussion_state') != 'visible') // soft deleted thread
		{
			$visitor = XenForo_Visitor::getInstance();
			if (!$visitor['is_moderator'] && $this->get('user_id') == $visitor['user_id']) // thread creator and not a moderator
			{
				UserEss_Model_UserLog::logUserAction('thread', $this->getMergedData(), 'delete_thread', array(), $this->_getForumData(), $visitor->toArray());
			}
		}
		
		if ($doDelete)
		{
			// delete who last locked the thread
			$threadId = $this->get('thread_id');
			$threadIdQuoted = $this->_db->quote($threadId);
			$this->_db->delete('useress_thread_lock', "thread_id = $threadIdQuoted");			
		}
	}
	
	/**
	 * Specific discussion post-delete behaviors.
	 */
	protected function _discussionPostDelete()
	{	
		// delete thread lock entry
		$threadId = $this->get('thread_id');
		$threadIdQuoted = $this->_db->quote($threadId);
		$this->_db->delete('useress_thread_lock', "thread_id = $threadIdQuoted");
		
		parent::_discussionPostDelete();
	}
}