<?php

/**
* Data writer for posts.
*
* @package UserEss
*/
class UserEss_DataWriter_DiscussionMessage_Post extends XFCP_UserEss_DataWriter_DiscussionMessage_Post
{
	/**
	 * Inserts a record for the edit history.
	 */
	protected function _insertEditHistory()
	{
		parent::_insertEditHistory();
		
		$visitor = XenForo_Visitor::getInstance()->toArray();
		if ($visitor['user_id'] == $this->get('user_id')) // post creator
		{
			// log the action
			UserEss_Model_UserLog::logUserAction('post', $this->getMergedData(), 'edit', array(), $this->getDiscussionData(), $visitor);
		}
	}
	
	protected function _messagePostSave()
	{
		// soft delete - now deleted but was visible
		if ($this->isUpdate() && $this->isChanged('message_state') && $this->get('message_state') != 'visible')
		{
			$visitor = XenForo_Visitor::getInstance()->toArray();
			if (!$visitor['is_moderator'] && $this->get('user_id') == $visitor['user_id']) // post creator and not a moderator
			{	
				// log the action
				UserEss_Model_UserLog::logUserAction('post', $this->getMergedData(), 'delete_post', array(), $this->getDiscussionData(), $visitor);
			}
		}
		
		parent::_messagePostSave();
	}
}