<?php

/**
* Data writer for user name change content.
*
* @package UserEss
*/
class UserEss_DataWriter_UNC extends XenForo_DataWriter
{
	/**
	 * Option to control whether or not to log the IP address of the message sender
	 *
	 * @var string
	 */
	const OPTION_SET_IP_ADDRESS = 'setIpAddress';
	
	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		return array(
				'useress_unc'		=> array(
				'unc_id'			=> array('type' => self::TYPE_UINT, 'autoIncrement' => true),
				'user_id'			=> array('type' => self::TYPE_UINT, 'required' => true),
				'from_username' 	=> array('type' => self::TYPE_STRING, 'maxLength' => 50, 'required' => true),
				'to_username'   	=> array('type' => self::TYPE_STRING, 'maxLength' => 50, 'required' => true),
				'date'   			=> array('type' => self::TYPE_UINT, 'default' => XenForo_Application::$time),
				'ip_address'		=> array('type' => self::TYPE_STRING, 'default' => '',	'verification' => array('$this', '_verifyIpAddress')),
				'via_acp'			=> array('type' => self::TYPE_UINT, 'required' => false),
				'user_note' 		=> array('type' => self::TYPE_STRING, 'maxLength' => 255, 'required' => false),
				'moderator_note' 	=> array('type' => self::TYPE_STRING, 'maxLength' => 255, 'required' => false),
				'moderator_id'		=> array('type' => self::TYPE_UINT, 'default' => 0),
				'moderation_date'   => array('type' => self::TYPE_UINT, 'default' => 0),
				'status'			=> array('type' => self::TYPE_STRING, 'default' => 'approved',
					'allowedValues' => array('approved', 'denied', 'moderated')
				)
			)
		);
	}

	/**
	* Gets the actual existing data out of data that was passed in. See parent for explanation.
	*
	* @param mixed
	*
	* @return array|false
	*/
	protected function _getExistingData($data)
	{
		if (!$uncId = $this->_getExistingPrimaryKey($data, 'unc_id'))
		{
			return false;
		}

		return array('useress_unc' => $this->_getUNCModel()->getUNCById($uncId));
	}

	/**
	* Gets SQL condition to update the existing record.
	*
	* @return string
	*/
	protected function _getUpdateCondition($tableName)
	{
		return 'unc_id = ' . $this->_db->quote($this->getExisting('unc_id'));
	}
	
	/**
	 * Gets the data writer's default options.
	 *
	 * @return array
	 */
	protected function _getDefaultOptions()
	{
		return array(
			self::OPTION_SET_IP_ADDRESS => true
		);
	}
	
	protected function _verifyIpAddress(&$ipAddress)
	{
		$ipAddress = (string)XenForo_Helper_Ip::convertIpStringToBinary($ipAddress);

		return true;
	}
	
	/**
	 * Pre-save handling.
	 */
	protected function _preSave()
	{
		if ($this->isInsert() && $this->getOption(self::OPTION_SET_IP_ADDRESS) && !$this->get('ip_address') && isset($_SERVER['REMOTE_ADDR']))
		{
			$this->set('ip_address', $_SERVER['REMOTE_ADDR']);
		}
	}
	
	/**
	 * @return UserEss_Model_UNC
	 */
	protected function _getUNCModel()
	{
		return $this->getModelFromCache('UserEss_Model_UNC');
	}
}