<?php

/**
* Data writer for users.
*
* @package UserEss
*/
class UserEss_DataWriter_User extends XFCP_UserEss_DataWriter_User
{
	/**
	 * Post-delete handling.
	 */
	protected function _postDelete()
	{
		parent::_postDelete();
		$db = $this->_db;
		$userId = $this->get('user_id');
		
		// get all name changes for this user that have the moderated status
		// should only be a max of one but better safe than sorry
		$uncs = $this->getModelFromCache('UserEss_Model_UNC')->getUNCByUserId($userId, array('status' => 'moderated'));
		
		if (!empty($uncs))
		{
			$contentIds = array_keys($uncs);
			$contentType = 'unc'; 
		
			// delete from moderation queue
			$db->delete('xf_moderation_queue',
				'content_type = ' . $db->quote($contentType) . ' AND content_id IN (' . $db->quote($contentIds) . ')'
			);
		
			$this->getModelFromCache('XenForo_Model_ModerationQueue')->rebuildModerationQueueCountCache();
		}
		
		$userIdQuoted = $db->quote($userId);
		
		// only keep the records if not allowed to use previous names
		if (XenForo_Application::get('options')->uncAllowPreviousNames)
		{
			$db->delete('useress_unc', "user_id = $userIdQuoted");
		}
		
		// delete from custom title cron
		$db->delete('useress_unc_cron', "user_id = $userIdQuoted");
	}
	
	protected function _postSaveAfterTransaction()
	{
		// admin is changing the custom title
		if ($this->isUpdate() && $this->getOption(self::OPTION_ADMIN_EDIT) && $this->isChanged('custom_title'))
		{
			// delete from custom title cron
			$db = $this->_db;
			$userIdQuoted = $db->quote($this->get('user_id'));
			$db->delete('useress_unc_cron', "user_id = $userIdQuoted");		
		}
	}
}