<?php

class UserEss_Install_Construct
{
	public static function install($existingAddOn, $addOnData)
	{
		if (XenForo_Application::$versionId < 1040031)
		{
			throw new XenForo_Exception('This Add-On requires XenForo version 1.4.0 or newer.');
		}
		
		$db = XenForo_Application::get('db');
		
		if ($existingAddOn) // upgrade
		{
			$versionId = $existingAddOn['version_id'];
			
			if ($versionId < 112)
			{
				throw new XenForo_Exception('This upgrade requires User Essentials version 1.1.2 to be installed.');
			}
			
			if ($versionId < 113)
			{
				$addOnModel = XenForo_Model::create('XenForo_Model_AddOn');
				$start = 0;
				XenForo_Db::beginTransaction($db);
				
				while ($start > -1)
				{
					// TRANSFER POST EDIT HISTORY to core system
					$postEdits = $addOnModel->fetchAllKeyed("
						SELECT 'post' AS content_type, post_edit.post_edit_id, post_edit.post_id AS content_id, post_edit.user_id AS edit_user_id, post_edit.date AS edit_date, post_edit.message AS old_text
						FROM useress_post_edit AS post_edit
						INNER JOIN xf_post AS post ON (post.post_id = post_edit.post_id)
						WHERE post_edit.post_edit_id > ?
						ORDER BY post_edit.post_edit_id ASC
						LIMIT 100
					", 'post_edit_id', $start);
					
					if (!empty($postEdits))
					{
						$editArray = array();
						
						// INSERT EDITS
						foreach ($postEdits AS $postEdit)
						{
							if (empty($postEdit['old_text'])) // no history, so skip
								continue;
							
							unset($postEdit['post_edit_id']); // was only needed for the key value in the array
							
							$editWriter = XenForo_DataWriter::create('XenForo_DataWriter_EditHistory');
							$editWriter->bulkSet($postEdit);
							$editWriter->save();
							
							$contentId = $postEdit['content_id'];
							if (isset($editArray[$contentId]))
							{
								$editArray[$contentId]['edit_count'] += 1;
								
								if ($editArray[$contentId]['edit_date'] < $postEdit['edit_date'])
								{
									$editArray[$contentId]['edit_date'] = $postEdit['edit_date'];
									$editArray[$contentId]['edit_user_id'] = $postEdit['edit_user_id'];
								}
							}
							else
							{
								$editArray[$contentId] = array('edit_count' => 1, 'edit_date' => $postEdit['edit_date'], 'edit_user_id' => $postEdit['edit_user_id']);
							}
						}
						
						end($postEdits);
						$start = key($postEdits); // continue from last post_edit_id
						
						if (!empty($editArray))
						{
							// UPDATE POST INFO
							$postIds = array_keys($editArray);
							$editHistories = $addOnModel->fetchAllKeyed("
								SELECT DISTINCT content_id, edit_user_id, edit_date
								FROM xf_edit_history
								WHERE content_type = 'post' AND content_id IN (" . $db->quote($postIds) . ")
								ORDER BY edit_date ASC
							", 'content_id');
							
							foreach ($editHistories AS $postId => $editHistory)
							{
								$postWriter = XenForo_DataWriter::create('XenForo_DataWriter_DiscussionMessage_Post');
								$postWriter->setExistingData($postId);
								$postWriter->setOption(XenForo_DataWriter_DiscussionMessage::OPTION_LOG_EDIT, false);
								$postWriter->setOption(XenForo_DataWriter_DiscussionMessage::OPTION_EDIT_DATE_DELAY, -1);
								$postWriter->setOption(XenForo_DataWriter_DiscussionMessage::OPTION_IS_AUTOMATED, true);
								$postWriter->set('edit_count', $postWriter->get('edit_count') + $editArray[$postId]['edit_count']);
								
								// last edit was done via UserEss so insert the last edit info
								if ($editHistory['edit_date'] <= $editArray[$postId]['edit_date'])
								{
									$postWriter->set('last_edit_date', $editHistory['edit_date']);
									$postWriter->set('last_edit_user_id', $editHistory['edit_user_id']);
								}
								else // last edit was done via XenForo 1.2.0
								{
									// last edit was done silently by a moderator so insert last edit info from UserEss
									if (!$postWriter->get('last_edit_date'))
									{
										$postWriter->set('last_edit_date', $editArray[$postId]['edit_date']);
										$postWriter->set('last_edit_user_id', $editArray[$postId]['edit_user_id']);								
									}
								}
								
								$postWriter->save();
							}
						}
					}
					else
					{
						$start = -1; // break
					}
				}
				
				// DELETE TABLES
				$db->query("
					DROP TABLE IF EXISTS useress_post_edit
				");
				
				XenForo_Db::commit($db);
				
				// REMOVE PERMISSIONS
				$db->query("
					DELETE FROM xf_permission_entry
					WHERE permission_id IN ('logEditPostLimit')
				");
				
				$db->query("
					DELETE FROM xf_permission_entry_content
					WHERE permission_id IN ('logEditPostLimit')
				");
				
				$usergroups = XenForo_Model::create('XenForo_Model_UserGroup')->getAllUserGroups();
				foreach($usergroups AS $usergroup)
				{
					$db->query("
						INSERT IGNORE INTO xf_permission_entry	(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
						VALUES (" . $usergroup['user_group_id'] . ", 0, 'forum', 'createPoll', 'allow', 0)
					");
				}
			}
			
			if ($versionId < 200)
			{
				$db->query("
					INSERT IGNORE INTO xf_content_type (content_type, addon_id)
					VALUES ('unc', 'UserEss')
				");
				
				$db->query("
					INSERT IGNORE INTO xf_content_type_field (content_type, field_name, field_value)
					VALUES
					('unc', 'moderation_queue_handler_class', 'UserEss_ModerationQueueHandler_UNC'),
					('unc', 'moderator_log_handler_class', 'UserEss_ModeratorLogHandler_UNC'),
					('unc', 'alert_handler_class', 'UserEss_AlertHandler_UNC')
				");
				
				$tableColumns = $db->describeTable('useress_unc');
				$ipAddress = array_key_exists('ip_address', $tableColumns);
				$userNote = array_key_exists('user_note', $tableColumns);
				$moderatorNote = array_key_exists('moderator_note', $tableColumns);
				$moderatorId = array_key_exists('moderator_id', $tableColumns);
				$moderationDate = array_key_exists('moderation_date', $tableColumns);
				$status = array_key_exists('status', $tableColumns);
				
				if (!$ipAddress && !$userNote && !$moderatorNote && !$moderatorId && !$moderationDate && !$status)
				{
					$db->query("
						ALTER TABLE useress_unc
						ADD ip_address INT UNSIGNED NOT NULL DEFAULT 0,
						ADD user_note VARCHAR(255) NOT NULL DEFAULT '',
						ADD moderator_note VARCHAR(255) NOT NULL DEFAULT '',
						ADD moderator_id INT UNSIGNED NOT NULL,
						ADD moderation_date INT UNSIGNED NOT NULL,
						ADD status ENUM('approved', 'denied', 'moderated') NOT NULL DEFAULT 'approved'
					");
				}
				else // installaion was interupted so check which are missing
				{
					if (!$ipAddress)
					{
						$db->query("
							ALTER TABLE useress_unc
							ADD ip_address INT UNSIGNED NOT NULL DEFAULT 0
						");
					}
					if (!$userNote)
					{
						$db->query("
							ALTER TABLE useress_unc
							ADD user_note VARCHAR(255) NOT NULL DEFAULT ''
						");
					}
					if (!$moderatorNote)
					{
						$db->query("
							ALTER TABLE useress_unc
							ADD moderator_note VARCHAR(255) NOT NULL DEFAULT ''
						");
					}
					if (!$moderatorId)
					{
						$db->query("
							ALTER TABLE useress_unc
							ADD moderator_id INT UNSIGNED NOT NULL
						");	
					}
					if (!$moderationDate)
					{
						$db->query("
							ALTER TABLE useress_unc
							ADD moderation_date INT UNSIGNED NOT NULL
						");	
					}
					if (!$status)
					{
						$db->query("
							ALTER TABLE useress_unc
							ADD status ENUM('approved', 'denied', 'moderated') NOT NULL DEFAULT 'approved'
						");		
					}
				}
				
				// USER NAME CHANGE CRON
				$db->query("
					CREATE TABLE IF NOT EXISTS useress_unc_cron (
						user_id INT UNSIGNED NOT NULL PRIMARY KEY,
						date INT UNSIGNED NOT NULL,
						old_custom_title VARCHAR(50) NOT NULL DEFAULT '',
						new_custom_title VARCHAR(50) NOT NULL DEFAULT ''
					) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
				");
			}
			
			if ($versionId < 204)
			{
				if ($versionId < 118 || $versionId > 199) // ensure original UserEss, if installed, has not already corrected the IP issue
				{
					$db->query("
						ALTER TABLE useress_user_log
							CHANGE ip_address ip_address_old INT UNSIGNED NOT NULL DEFAULT 0,
							ADD ip_address VARBINARY(16) NOT NULL DEFAULT ''
					");
					
					$db->query("
						UPDATE useress_user_log SET ip_address = UNHEX(LPAD(HEX(ip_address_old), 8, '0'))
					");
					
					$db->query("
						ALTER TABLE useress_user_log DROP ip_address_old
					");
				}
				
				$db->query("
					ALTER TABLE useress_unc
						CHANGE ip_address ip_address_old INT UNSIGNED NOT NULL DEFAULT 0,
						ADD ip_address VARBINARY(16) NOT NULL DEFAULT ''
				");
				
				$db->query("
					UPDATE useress_unc SET ip_address = UNHEX(LPAD(HEX(ip_address_old), 8, '0'))
				");
				
				$db->query("
					ALTER TABLE useress_unc DROP ip_address_old
				");
			}
			
			if ($versionId < 207)
			{
				$db->query("
					DELETE FROM xf_permission_entry
					WHERE permission_id IN ('addPollToOwnThread', 'addPollToOwnThreadLimit', 'unvotePollLimit')
				");
				
				$db->query("
					DELETE FROM xf_permission_entry_content
					WHERE permission_id IN ('addPollToOwnThread', 'addPollToOwnThreadLimit', 'unvotePollLimit')
				");
			}
		}
		else // freash install
		{
			// set default permission values
			$usergroups = XenForo_Model::create('XenForo_Model_UserGroup')->getAllUserGroups();
			foreach($usergroups AS $usergroup)
			{
				// THREAD TITLE TIME LIMIT
				// CREATE POLL
				$db->query("
					INSERT INTO xf_permission_entry	(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
					VALUES
					(" . $usergroup['user_group_id'] . ", 0, 'forum', 'editOwnThreadTitleLimit', 'use_int', -1),
					(" . $usergroup['user_group_id'] . ", 0, 'forum', 'createPoll', 'allow', 0)
				");
			}
			
			// USER NAME CHANGE
			$db->query("
				CREATE TABLE IF NOT EXISTS useress_unc (
					unc_id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
					user_id INT UNSIGNED NOT NULL,
					from_username VARCHAR(50) NOT NULL,
					to_username VARCHAR(50) NOT NULL,
					date INT UNSIGNED NOT NULL,
					via_acp TINYINT UNSIGNED NOT NULL DEFAULT 0,
					ip_address VARBINARY(16) NOT NULL DEFAULT '',
					user_note VARCHAR(255) NOT NULL DEFAULT '',
					moderator_note VARCHAR(255) NOT NULL DEFAULT '',
					moderator_id INT UNSIGNED NOT NULL,
					moderation_date INT UNSIGNED NOT NULL,
					status ENUM('approved', 'denied', 'moderated') NOT NULL DEFAULT 'approved',
					KEY user_id (user_id)
				) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
			");
			
			// USER NAME CHANGE CRON
			$db->query("
				CREATE TABLE IF NOT EXISTS useress_unc_cron (
					user_id INT UNSIGNED NOT NULL PRIMARY KEY,
					date INT UNSIGNED NOT NULL,
					old_custom_title VARCHAR(50) NOT NULL DEFAULT '',
					new_custom_title VARCHAR(50) NOT NULL DEFAULT ''
				) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
			");
			
			// USER LOG
			$db->query("
				CREATE TABLE useress_user_log (
					user_log_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
					log_date INT UNSIGNED NOT NULL,
					user_id INT UNSIGNED NOT NULL,
					ip_address VARBINARY(16) NOT NULL DEFAULT '',
					content_type VARCHAR(25) NOT NULL,
					content_id INT UNSIGNED NOT NULL,
					content_user_id INT UNSIGNED NOT NULL,
					content_username VARCHAR(50) NOT NULL,
					content_title VARCHAR(150) NOT NULL,
					content_url text NOT NULL,
					discussion_content_type VARCHAR(25) NOT NULL,
					discussion_content_id INT UNSIGNED NOT NULL,
					action VARCHAR(25) NOT NULL,
					action_params MEDIUMBLOB NOT NULL,
					PRIMARY KEY (user_log_id),
					KEY log_date (log_date),
					KEY user_id_content_type_id (user_id, content_type, content_id),
					KEY user_id_log_date (user_id, log_date)
				) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
			");
			
			// THREAD LOCK
			$db->query("
				CREATE TABLE IF NOT EXISTS useress_thread_lock (
					thread_id INT UNSIGNED NOT NULL,
					user_id INT UNSIGNED NOT NULL,
					PRIMARY KEY (thread_id)
				) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
			");
			
			// CONTENT TYPES
			$db->query("
				INSERT IGNORE INTO xf_content_type (content_type, addon_id)
				VALUES ('unc', 'UserEss')
			");
			
			// CONTENT TYPE	FIELDS	
			$db->query("
				INSERT IGNORE INTO xf_content_type_field (content_type, field_name, field_value)
				VALUES
				('thread', 'user_log_handler_class', 'UserEss_UserLogHandler_Thread'),
				('post', 'user_log_handler_class', 'UserEss_UserLogHandler_Post'),
				('user', 'user_log_handler_class', 'UserEss_UserLogHandler_User'),
				('unc', 'moderation_queue_handler_class', 'UserEss_ModerationQueueHandler_UNC'),
				('unc', 'moderator_log_handler_class', 'UserEss_ModeratorLogHandler_UNC'),
				('unc', 'alert_handler_class', 'UserEss_AlertHandler_UNC')
			");
		}
		
		XenForo_Model::create('XenForo_Model_ContentType')->rebuildContentTypeCache();
	}
	
	public static function uninstall()
	{
		$db = XenForo_Application::get('db');
		
		$db->query("
			DELETE FROM xf_permission_entry
			WHERE permission_id IN ('editOwnThreadTitleLimit', 'addPollToOwnThread', 'addPollToOwnThreadLimit', 'canUserNameChange', 'createPoll', 'lockUnlockOwnThread', 'manageUserNameChange', 'unvotePollLimit')
		");
		
		$db->query("
			DELETE FROM xf_permission_entry_content
			WHERE permission_id IN ('editOwnThreadTitleLimit', 'addPollToOwnThread', 'addPollToOwnThreadLimit', 'canUserNameChange', 'createPoll', 'lockUnlockOwnThread', 'manageUserNameChange', 'unvotePollLimit')
		");
				
		$db->query("
			DROP TABLE IF EXISTS useress_unc
		");
		
		$db->query("
			DROP TABLE IF EXISTS useress_unc_cron
		");
		
		$db->query("
			DROP TABLE IF EXISTS useress_user_log
		");
		
		$db->query("
			DROP TABLE IF EXISTS useress_thread_lock
		");
		
		$db->query("
			DELETE FROM xf_content_type_field
			WHERE content_type = 'thread' AND field_name = 'user_log_handler_class' AND field_value = 'UserEss_UserLogHandler_Thread'
		");
		
		$db->query("
			DELETE FROM xf_content_type_field
			WHERE content_type = 'post' AND field_name = 'user_log_handler_class' AND field_value = 'UserEss_UserLogHandler_Post'
		");
		
		$db->query("
			DELETE FROM xf_content_type_field
			WHERE content_type = 'user' AND field_name = 'user_log_handler_class' AND field_value = 'UserEss_UserLogHandler_User'
		");
		
		$db->query("
			DELETE FROM xf_content_type_field
			WHERE content_type = 'unc'
		");
		
		$db->query("
			DELETE FROM xf_content_type
			WHERE addon_id = 'UserEss'
		");
		
		$db->query("
			DELETE FROM xf_user_alert
			WHERE content_type = 'unc'
		");
		
		$db->query("
			DELETE FROM xf_moderation_queue
			WHERE content_type = 'unc'
		");
		
		$db->query("
			DELETE FROM xf_moderator_log
			WHERE content_type = 'unc'
		");
		
		XenForo_Model::create('XenForo_Model_ModerationQueue')->rebuildModerationQueueCountCache();
		
		XenForo_Model::create('XenForo_Model_ContentType')->rebuildContentTypeCache();
	}
}