<?php

class UserEss_Listener_Hook
{
	// preload the templates
	public static function templateCreate($templateName, array &$params, XenForo_Template_Abstract $template)
	{
		if ($templateName == 'account_wrapper')
		{
			$template->preloadTemplate('useress_unc_account_wrapper_sidebar_settings');
		}
		else if ($templateName == 'member_view')
		{
			$displayProfileTab = XenForo_Application::get('options')->useressDisplayProfileTab;
			
			if ($displayProfileTab != 'nobody')
			{
				$member = $params['user'];
				$doDisplay = self::_doDisplayProfileTab($member);
				
				if ($doDisplay)
				{
					$params['useress_unc'] = true; // include the name change tab
					$template->preloadTemplate('useress_member_view_tabs_heading');
					$template->preloadTemplate('useress_member_view_tabs_content');
				}
			}
		}
	}
	
	// hook name
	public static function template($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
		if ($hookName == 'account_wrapper_sidebar_settings')
		{
			self::userNameChange($contents, $hookParams, $template);
		}
		else if ($hookName == 'member_view_tabs_heading')
		{
			self::addNameChangeTab($contents, $hookParams, $template);
		}
		else if ($hookName == 'member_view_tabs_content')
		{
			self::addNameChangeTabContent($contents, $hookParams, $template);
		}
	}

	// add the user name change page link
	private static function userNameChange(&$contents, $hookParams, XenForo_Template_Abstract $template)
	{
		$visitor = XenForo_Visitor::getInstance()->toArray();
		$uncModel = XenForo_Model::create('UserEss_Model_UNC');
		if ($visitor['user_id'] && $uncModel->canUserNameChange($visitor))
		{
            $hookParams['selectedKey'] = $template->getParam('selectedKey');
			$contents .= $template->create('useress_unc_account_wrapper_sidebar_settings', $hookParams);
		}
	}
	
	//  display 'Name Change' tab on member page
	private static function addNameChangeTab(&$contents, $hookParams, XenForo_Template_Abstract $template)
	{
		$displayProfileTab = XenForo_Application::get('options')->useressDisplayProfileTab;
		
		if ($displayProfileTab != 'nobody')
		{
			$doDisplay = $template->getParam('useress_unc');
			if ($doDisplay)
			{
				$hookParams['requestPaths'] = $template->getParam('requestPaths');
				$contents .= $template->create('useress_member_view_tabs_heading', $hookParams);
			}
		}
	}
	
	//  display 'Name Change' member page tab content
	private static function addNameChangeTabContent(&$contents, $hookParams, XenForo_Template_Abstract $template)
	{
		$displayProfileTab = XenForo_Application::get('options')->useressDisplayProfileTab;
		
		if ($displayProfileTab != 'nobody')
		{
			$doDisplay = $template->getParam('useress_unc');
			if ($doDisplay)
			{
				$contents .= $template->create('useress_member_view_tabs_content', $hookParams);
			}
		}
	}
	
	// whether or not we need to display the profile tab for user name changes
	private static function _doDisplayProfileTab(array $member)
	{
		if (empty($member) || !isset($member['user_id']))
			return false;
		
		$memberId = $member['user_id'];
		
		$displayProfileTab = XenForo_Application::get('options')->useressDisplayProfileTab;
		$visitor = XenForo_Visitor::getInstance();
		$doDisplay = false;
		
		if ($displayProfileTab == 'everybody')
		{
			$doDisplay = true;
		}
		else
		{
			if ($displayProfileTab == 'members' && $visitor['user_id'] > 0)
			{
				$doDisplay = true;
			}
			else if ($displayProfileTab == 'mods' || $displayProfileTab == 'mods_and_member')
			{
				if ($displayProfileTab == 'mods_and_member' && $visitor['user_id'] == $memberId)
				{
					$doDisplay = true;
				}
				else if ($visitor['is_moderator'] || $visitor['is_admin'] )
				{
					$doDisplay = true;
				}
			}
		}
		
		// now check that we actually have previous names to display. Otherwise no point showing the tab.
		if ($doDisplay)
		{
			$conditions = array();
			
			// do we count name changes made via the ACP?
			if (!XenForo_Application::get('options')->uncDisplayChangesViaACP)
				$conditions['skip_acp'] = 1;
			
			$conditions['status'] = 'approved';
			
			// moderation is on so fetch status if necessary
			if (XenForo_Application::get('options')->uncModerate)
			{
				if (($visitor['is_moderator'] || $visitor['is_admin']) || ($visitor['user_id'] == $memberId))
				{
					unset($conditions['status']); // fetch all
				}
			}
			
			$uncModel = XenForo_Model::create('UserEss_Model_UNC');
			$hasPreviousNames = $uncModel->countUNCByUserId($memberId, $conditions);
			
			if (!$hasPreviousNames)
				$doDisplay = false;
		}
		
		return $doDisplay;
	}
}