<?php

/**
 * Model for forums.
 *
 * @package UserEss
 */
class UserEss_Model_Forum extends XFCP_UserEss_Model_Forum
{
	/**
	 * Determines if a thread can be locked or unlocked in the specified forum
	 * with the given permissions.
	 *
	 * @param array $forum
	 * @param string $errorPhraseKey
	 * @param array|null $nodePermissions
	 * @param array|null $viewingUser
	 *
	 * @return boolean
	 */
	public function canLockUnlockThreadInForum(array $forum, &$errorPhraseKey = '', array $nodePermissions = null, array $viewingUser = null)
	{
		$this->standardizeViewingUserReferenceForNode($forum['node_id'], $viewingUser, $nodePermissions);
		
		if (!$viewingUser['user_id'])
		{
			return false;
		}
		
		$canLockUnlock = parent::canLockUnlockThreadInForum($forum, $errorPhraseKey, $nodePermissions, $viewingUser);
		if (!$canLockUnlock)
		{
			$canLockUnlock = XenForo_Permission::hasContentPermission($nodePermissions, 'lockUnlockOwnThread');
		}

		return $canLockUnlock;
	}
	
	/**
	 * Determines if a poll can be added in this forum. This does not check
	 * general thread posting permissions.
	 *
	 * @param array $forum Info about the forum posting in
	 * @param string $errorPhraseKey Returned phrase key for a specific error
	 * @param array|null $nodePermissions
	 * @param array|null $viewingUser
	 *
	 * @return boolean
	 */
	public function canPostPollInForum(array $forum, &$errorPhraseKey = '', array $nodePermissions = null, array $viewingUser = null)
	{
		$canAddPoll = parent::canPostPollInForum($forum, $errorPhraseKey, $nodePermissions, $viewingUser);
		
		// now check for user group permission
		if ($canAddPoll)
		{
			$this->standardizeViewingUserReferenceForNode($forum['node_id'], $viewingUser, $nodePermissions);
			
			if (!XenForo_Permission::hasContentPermission($nodePermissions, 'createPoll'))
			{
				$canAddPoll = false;
			}
		}
		
		return $canAddPoll;
	}
}