<?php

/**
 * Model for logging IPs and querying them.
 *
 * @package UserEss
 */
class UserEss_Model_Ip extends XFCP_UserEss_Model_Ip
{
	/**
	 * Gets IP info for an online user
	 *
	 * @param array $onlineUser
	 *
	 * @return array (contentIp, contentHost, registrationIp, registrationHost, confirmationIp, confirmationHost)
	 */
	public function getBasicIpInfo($ip)
	{
		$contentIp = long2ip($ip);
		$contentHost = $this->_getHost($contentIp);

		return array('contentIp' => (empty($contentIp) ? false : $contentIp), 'contentHost' => (empty($contentHost) ? false : $contentHost));
	}
}