<?php

/**
 * Model for the moderation queue.
 *
 * @package UserEss
 */
class UserEss_Model_ModerationQueue extends XFCP_UserEss_Model_ModerationQueue
{
	/**
	 * Saves changes to the moderation queue. Takes into account the specified user's permissions.
	 *
	 * @param array $changes Format: [type][id] => [action (approve/delete), message, title]
	 * @param array|null $viewingUser
	 */
	public function saveModerationQueueChanges(array $changes, array $viewingUser = null)
	{
		$entries = $this->getVisibleModerationQueueEntriesForUser($this->getModerationQueueEntries(), $viewingUser);
		$handlers = $this->getModerationQueueHandlers();
		$handler = $handlers['unc'];
		
		foreach ($entries AS $entry)
		{
			if ($entry['content_type'] != 'unc')
			{
				continue;
			}
			
			if (!isset($changes['unc'][$entry['content_id']]))
			{
				continue;
			}
			
			$change = $changes['unc'][$entry['content_id']];
			if (!is_array($change) || empty($change['action']))
			{
				continue;
			}
			
			$note = (isset($change['note']) ? $change['note'] : '');
			
			if ($change['action'] == 'approve')
			{
				$handler->approvedModerationQueueEntry($entry['content_id'], $note);
			}
			else if ($change['action'] == 'delete')
			{
				$handler->deniedModerationQueueEntry($entry['content_id'], $note);
			}
		}
		
		// remove them as they have now been dealt with
		unset($changes['unc']);
		
		// now deal with all other content types
		return parent::saveModerationQueueChanges($changes, $viewingUser);
	}
}