<?php

/**
 * Model for polls.
 *
 * @package UserEss
 */
class UserEss_Model_Poll extends XFCP_UserEss_Model_Poll
{
	/**
	 * Gets poll vote for specific poll and user.
	 *
	 * @param integer $pollId
	 * @param integer $userId
	 *
	 * @return array|false
	 */
	public function getPollVoteDateByPollIdUserId($pollId, $userId)
	{
		return $this->_getDb()->fetchOne('
			SELECT vote_date
			FROM xf_poll_vote
			WHERE poll_id = ? AND user_id = ?
			LIMIT 1
		', array($pollId, $userId));
	}
	
	/**
	 * Delete poll votes for specific poll and user.
	 *
	 * @param integer $pollId
	 * @param integer $userId
	 *
	 * @return array|false
	 */
	public function deletePollVoteByPollIdUserId($pollId, $userId)
	{
		return $this->_getDb()->fetchRow('
			DELETE FROM xf_poll_vote
			WHERE poll_id = ? AND user_id = ?
		', array($pollId, $userId));
	}
	
	/**
	 * Prepares the poll for viewing.
	 *
	 * @param array $poll
	 * @param boolean $canVote If user can vote based on content-specified permissions
	 * @param array|null $viewingUser
	 *
	 * @return array
	 */
	public function preparePoll(array $poll, $canVote, array $viewingUser = null)
	{
		$poll = parent::preparePoll($poll, $canVote, $viewingUser);
		
		if ($poll['hasVoted'] && $poll['open'])
		{
			// cannot use $canVote as it is not always a true representative of the action
			// for example, right after a vote it simply flagged as false without any checks
			
			$errorPhraseKey = '';
			$poll['canUnvote'] = $this->_getThreadModel()->canUnvoteOnPoll($poll, $errorPhraseKey, $viewingUser);
		}
		else
		{
			$poll['canUnvote'] = false;
		}
		
		return $poll;
	}
	
	/**
	 * @return XenForo_Model_Thread
	 */
	protected function _getThreadModel()
	{
		return $this->getModelFromCache('XenForo_Model_Thread');
	}
}