<?php

/**
 * Model for posts.
 *
 * @package UserEss
 */
class UserEss_Model_Post extends XFCP_UserEss_Model_Post
{	
	/**
	 * Determines if the post can be edited with the given permissions.
	 * This does not check post viewing permissions.
	 *
	 * @param array $post Info about the post
	 * @param array $thread Info about the thread this post is in
	 * @param array $forum Info about the forum the thread is in
	 * @param string $errorPhraseKey Returned phrase key for a specific error
	 * @param array|null $nodePermissions
	 * @param array|null $viewingUser
	 *
	 * @return boolean
	 */
	public function canEditPost(array $post, array $thread, array $forum, &$errorPhraseKey = '', array $nodePermissions = null, array $viewingUser = null)
	{
		$canEdit = parent::canEditPost($post, $thread, $forum, $errorPhraseKey, $nodePermissions, $viewingUser);
		
		if (!$canEdit && $errorPhraseKey == 'you_may_not_perform_this_action_because_discussion_is_closed')
		{
			if ($this->_getThreadModel()->canLockUnlockThread($thread, $forum, $errorPhraseKey, $nodePermissions, $viewingUser))
				$canEdit = true;
		}
		
		return $canEdit;
	}
		
	/**
	 * Checks the 'join' key of the incoming array for the presence of the FETCH_x bitfields in this class
	 * and returns SQL snippets to join the specified tables if required
	 *
	 * @param array $fetchOptions containing a 'join' integer key build from this class's FETCH_x bitfields
	 *
	 * @return array Containing 'selectFields' and 'joinTables' keys. Example: selectFields = ', user.*, foo.title'; joinTables = ' INNER JOIN foo ON (foo.id = other.id) '
	 */
	public function preparePostJoinOptions(array $fetchOptions)
	{
		$joinOptions = parent::preparePostJoinOptions($fetchOptions);
		
		if (XenForo_Visitor::getUserId())
		{
			if (!empty($fetchOptions['join']))
			{
				if ($fetchOptions['join'] & self::FETCH_THREAD)
				{
					$selectFields = ',
						IF(thread_lock.user_id IS NULL, 0, thread_lock.user_id) AS lockedByMod';
					$joinTables = '
						LEFT JOIN useress_thread_lock AS thread_lock ON(thread_lock.thread_id = thread.thread_id)';
			
					$joinOptions['selectFields'] .= $selectFields;
					$joinOptions['joinTables'] .= $joinTables;
				}
			}
		}
		
		return $joinOptions;
	}
	
	/**
	 * @return XenForo_Model_Thread
	 */
	protected function _getThreadModel()
	{
		return $this->getModelFromCache('XenForo_Model_Thread');
	}
	
	/**
	 * @return XenForo_Model_Forum
	 */
	protected function _getForumModel()
	{
		return $this->getModelFromCache('XenForo_Model_Forum');
	}
}