<?php

class UserEss_Model_UserLog extends XenForo_Model
{	
	public function getUserLogById($id)
	{
		return $this->_getDb()->fetchRow('
			SELECT user_log.*, user_log.content_username AS username
			FROM useress_user_log AS user_log
			WHERE user_log.user_log_id = ?
		', $id);
	}
	
	public function getUserLogEntries($fetchOptions)
	{
		$db = $this->_getDb();
		$limitOptions = $this->prepareLimitFetchOptions($fetchOptions);
		$where = $this->_prepareWhereClause($fetchOptions);
				
		return $this->fetchAllKeyed($this->limitQueryResults(
			'
				SELECT user_log.*, user_log.content_username AS username
				FROM useress_user_log AS user_log
				' . ($where ? 'WHERE ' . $where : '') . '
				ORDER BY user_log.log_date DESC
			', $limitOptions['limit'], $limitOptions['offset']
		), 'user_log_id');
	}

	public function countUserLogEntries($fetchOptions)
	{
		$db = $this->_getDb();
		$where = $this->_prepareWhereClause($fetchOptions);
		
		return $db->fetchOne('
			SELECT COUNT(*)
			FROM useress_user_log AS user_log
			' . ($where ? 'WHERE ' . $where : '')
		);
	}
	
	protected function _prepareWhereClause($fetchOptions)
	{
		$db = $this->_getDb();
		$userId = 0;
		$username = '';
		$action = '';
		$where = '';
		
		if (isset($fetchOptions['userId']))
			$userId = $fetchOptions['userId'];
		
		if (isset($fetchOptions['username']))
			$username = $fetchOptions['username'];
		
		if (isset($fetchOptions['action']))
			$action = $fetchOptions['action'];
			
		if ($userId)
			$where = 'user_log.user_id = ' . $db->quote($fetchOptions['userId']);
		else if (!empty($username))
			$where = 'user_log.content_username = ' . $db->quote($fetchOptions['username']);
		
		if (!empty($action))
		{
			if (!empty($where))
				$where .= ' AND ';
			
			if ($action == 'username')
				$where .= '(user_log.action = ' . $db->quote('username') . ' OR user_log.action = ' . $db->quote('username_request') . ')';
			else
				$where .= 'user_log.action = ' . $db->quote($fetchOptions['action']);
		}
		
		return $where;
	}
	
	public static function logUserAction(
		$contentType, array $content, $action, array $actionParams = array(),
		$parentContent = null, array $logUser = null
	)
	{
		return XenForo_Model::create(__CLASS__)->logUserActionLocal(
			$contentType, $content, $action, $actionParams, $parentContent, $logUser
		);
	}
	
	public function logUserActionLocal(
		$contentType, array $content, $action, array $actionParams = array(),
		$parentContent = null, array $logUser = null
	)
	{
		$handler = $this->getUserLogHandler($contentType);
		if (!$handler)
		{
			return false;
		}
		
		return $handler->log($content, $action, $actionParams, $parentContent, $logUser);
	}
	
	public function prepareUserLogEntry(array $entry)
	{
		$handler = $this->getUserLogHandler($entry['content_type']);
		if ($handler)
		{
			$entry = $handler->prepareEntry($entry);
		}
		
		return $entry;
	}
	
	/**
	 * Gets the mod log handler for a specific type of content.
	 *
	 * @param string $contentType
	 *
	 * @return UserLog_UserLogHandler_Abstract|false
	 */
	public function getUserLogHandler($contentType)
	{
		$handlerClass = $this->getContentTypeField($contentType, 'user_log_handler_class');
		if (!$handlerClass)
		{
			return false;
		}
		
		return new $handlerClass();
	}
	
	public function prepareUserLogEntries(array $entries)
	{
		$handlers = $this->getUserLogHandlers();
		
		foreach ($entries AS $key => &$entry)
		{
			if (isset($handlers[$entry['content_type']]))
			{
				$entry = $handlers[$entry['content_type']]->prepareEntry($entry);
			}
			else
			{
				unset($entries[$key]);
			}
		}
		
		return $entries;
	}
	
	/**
	 * Gets the user log handlers for all content types.
	 *
	 * @return array Array of UserLog_UserLogHandler_Abstract objects
	 */
	public function getUserLogHandlers()
	{
		$handlerClasses = $this->getContentTypesWithField('user_log_handler_class');
		$handlers = array();
		foreach ($handlerClasses AS $contentType => $handlerClass)
		{
			$handlers[$contentType] = new $handlerClass();
		}
		
		return $handlers;
	}
	
	public function getUsersWithUserLogs()
	{
		$userIds = $this->_getDb()->fetchCol('
			SELECT DISTINCT user_id
			FROM useress_user_log
		');
		if (!$userIds)
		{
			return array();
		}
		
		return $this->getModelFromCache('XenForo_Model_User')->getUsersByIds($userIds);
	}
	
	public function pruneLog($cutOffDate)
	{
		$cutOffDate = intval($cutOffDate);
		if (!$cutOffDate)
			return;
		
		$this->_getDb()->query("
			DELETE FROM useress_user_log
			WHERE log_date <= ?
		", $cutOffDate);
	}
	
	public function clearLog()
	{
		$this->_getDb()->query('TRUNCATE TABLE useress_user_log');
	}
}