<?php

class UserEss_ModeratorLogHandler_UNC extends XenForo_ModeratorLogHandler_Abstract
{
	protected function _log(array $logUser, array $content, $action, array $actionParams = array(), $parentContent = null)
	{
		if (!isset($actionParams['from_username']))
		{
			$phrase = new XenForo_Phrase('n_a');
			$actionParams['from_username'] = $phrase->render();
		}
		if (!isset($actionParams['to_username']))
		{
			$phrase = new XenForo_Phrase('n_a');
			$actionParams['to_username'] = $phrase->render();
		}
		
		if ($action == 'approved')
		{
			$contentTitle = $actionParams['to_username'];
		}
		else if ($action == 'denied')
		{
			$contentTitle = $actionParams['from_username'];
		}
		else
		{
			$phrase = new XenForo_Phrase('n_a');
			$contentTitle = $phrase->render();
		}
		
		$dw = XenForo_DataWriter::create('XenForo_DataWriter_ModeratorLog');
		$dw->bulkSet(array(
			'user_id' => $logUser['user_id'],
			'content_type' => 'unc',
			'content_id' => $content['user_id'],
			'content_user_id' => $content['user_id'],
			'content_username' => $content['username'],
			'content_title' => $contentTitle,
			'content_url' => XenForo_Link::buildPublicLink('members', $content),
			'discussion_content_type' => 'username',
			'discussion_content_id' => 0,
			'action' => $action,
			'action_params' => $actionParams
		));
		$dw->save();

		return $dw->get('moderator_log_id');
	}
	
	protected function _prepareEntry(array $entry)
	{
		$unc = json_decode($entry['action_params'], true);
		if (!empty($unc))
		{
			$entry['unc'] = $unc;
		}
		
		$entry['user'] = array('user_id' => $entry['content_user_id'], 'username' => $entry['content_username']);
		
		return $entry;
	}
}