<?php

abstract class UserEss_UserLogHandler_Abstract
{
	abstract protected function _log(array $logUser, array $content, $action, array $actionParams = array(), $parentContent = null);
	
	public function log(array $content, $action, array $actionParams = array(), $parentContent = null, array $logUser = null)
	{
		if ($logUser === null)
		{
			$logUser = XenForo_Visitor::getInstance()->toArray();
		}
		
		if (!$logUser['user_id'])
		{
			return false;
		}
		
		return $this->_log($logUser, $content, $action, $actionParams, $parentContent);
	}
	
	final public function prepareEntry(array $entry)
	{
		$entry['content_title'] = XenForo_Helper_String::censorString($entry['content_title']);
		$entry['ipAddress'] = ($entry['ip_address'] ? XenForo_Helper_Ip::convertIpBinaryToString($entry['ip_address']) : '');
		
		$entry = $this->_prepareEntry($entry);
		
		if (!isset($entry['actionText']))
		{
			$entry['actionText'] = new XenForo_Phrase(
				'useress_log_' . $entry['content_type'] . '_' . $entry['action'],
				json_decode($entry['action_params'], true)
			);
		}
		
		return $entry;
	}
	
	protected function _prepareEntry(array $entry)
	{
		return $entry;
	}
}