<?php

class UserEss_UserLogHandler_Thread extends UserEss_UserLogHandler_Abstract
{
	protected function _log(array $logUser, array $content, $action, array $actionParams = array(), $parentContent = null)
	{
		$dw = XenForo_DataWriter::create('UserEss_DataWriter_UserLog');
		$dw->bulkSet(array(
			'user_id' => $logUser['user_id'],
			'content_type' => 'thread',
			'content_id' => $content['thread_id'],
			'content_user_id' => $content['user_id'],
			'content_username' => $content['username'],
			'content_title' => $content['title'],
			'content_url' => XenForo_Link::buildPublicLink('threads', $content),
			'discussion_content_type' => 'thread',
			'discussion_content_id' => $content['thread_id'],
			'action' => $action,
			'action_params' => $actionParams
		));
		$dw->save();

		return $dw->get('user_log_id');
	}
	
	protected function _prepareEntry(array $entry)
	{
		$elements = json_decode($entry['action_params'], true);
			
		if (isset($elements['reason']) && !empty($elements['reason']))
		{
			$entry['reason'] = $elements['reason'];
		}

		return $entry;
	}
}