<?php

class UserEss_UserLogHandler_User extends UserEss_UserLogHandler_Abstract
{
	protected function _log(array $logUser, array $content, $action, array $actionParams = array(), $parentContent = null)
	{
		$dw = XenForo_DataWriter::create('UserEss_DataWriter_UserLog');
		$dw->bulkSet(array(
			'user_id' => $logUser['user_id'],
			'content_type' => 'user',
			'content_id' => $content['user_id'],
			'content_user_id' => $content['user_id'],
			'content_username' => $content['username'],
			'content_title' => ($action == 'username_request' ? new XenForo_Phrase('useress_unc_old_user_name') .': ' : new XenForo_Phrase('useress_unc_new_user_name') .': ') . $content['username'],
			'content_url' => XenForo_Link::buildPublicLink('members', $content),
			'discussion_content_type' => 'username',
			'discussion_content_id' => 0,
			'action' => $action,
			'action_params' => $actionParams
		));
		$dw->save();

		return $dw->get('user_log_id');
	}
}