<?php

/**
 *
 * @see XenForo_ViewAdmin_CssInternal
 */
class Waindigo_AdminStyles_Extend_XenForo_ViewAdmin_CssInternal extends XFCP_Waindigo_AdminStyles_Extend_XenForo_ViewAdmin_CssInternal
{

    /**
     *
     * @see XenForo_ViewAdmin_CssInternal::renderCss()
     */
    public function renderCss()
    {
        $css = parent::renderCss();
        
        $templateParams = array(
            'displayStyles' => array(),
            'smilieSprites' => array(),
            'xenOptions' => XenForo_Application::get('options'),
            'dir' => $this->_params['dir'],
            'pageIsRtl' => ($this->_params['dir'] == 'RTL')
        );
        
        $adminCss = "";
        foreach ($this->_params['css'] as $cssTemplate) {
            if ($cssTemplate == "ADMIN.css") {
                $template = new XenForo_Template_Public('ADMIN.css', $templateParams);
                $template->setStyleId(XenForo_Application::get('options')->waindigo_adminStyles_adminStyleId);
                $adminCss = XenForo_CssOutput::renderCssFromObjects(array(
                    'ADMIN.css' => $template
                ), true);
                $adminCss = XenForo_CssOutput::prepareCssForOutput($adminCss, $this->_params['dir'], false);
            }
        }
        
        return $css . $adminCss;
    } /* END renderCss */
}