<?php

class Waindigo_AdminStyles_Install_Controller extends Waindigo_Install
{

    protected $_resourceManagerUrl = 'http://xenforo.com/community/resources/admin-styles-by-waindigo.2201/';
    
    protected function _postInstall()
    {
        /* @var $styleModel XenForo_Model_Style */
        $styleModel = $this->getModelFromCache('XenForo_Model_Style');
        
        $allStyles = $styleModel->getAllStyles();
        
        $style = array();
        foreach ($allStyles as $testStyle) {
            if ($testStyle['title'] == 'Default Admin Style') {
                $style = $testStyle;
                break;
            }
        }
        
        if (empty($style)) {
            /* @var $dw XenForo_DataWriter_Style */
            $dw = XenForo_DataWriter::create('XenForo_DataWriter_Style');
            $dw->bulkSet(array(
                'title' => 'Default Admin Style',
                'description' => 'Imported from default admin style',
                'user_selectable' => false
            ));
            $dw->save();
            
            $style = $dw->getMergedData();
            
            $styleModel->rebuildStyleParentListRecursive($style['style_id']);
            
            $styleProperties = XenForo_Application::getDb()->fetchAll('
                SELECT style_property_definition.*, style_property.property_value
                FROM xf_style_property AS style_property,
                    xf_style_property_definition AS style_property_definition
                WHERE style_id = \'-1\'
                    AND style_property.property_definition_id = style_property_definition.property_definition_id
            ');
            
            foreach ($styleProperties as $styleProperty) {
                if ($styleProperty['property_type'] == "css") {
                    $newValue = unserialize($styleProperty['property_value']);
                } else {
                    $newValue = $styleProperty['property_value'];
                }
                $this->getModelFromCache('XenForo_Model_StyleProperty')->updateStylePropertyValue($styleProperty, $style['style_id'], $newValue);
            }
        }
        
        if (XenForo_Application::$versionId >= 1020000) {
            foreach ($this->_xml->optiongroups->option as $option) {
                /* @var $option SimpleXMLElement */
                if ($option['option_id'] == 'waindigo_adminStyles_adminStyleId') {
                    $option->default_value = $style['style_id'];
                }
            }
        }
    } /* END _postInstall */
}