<?php

class Waindigo_AdminStyles_Listener_InitDependencies extends Waindigo_Listener_InitDependencies
{

    public function run()
    {
        if (!self::$_dependencies instanceof XenForo_Dependencies_Admin) {
            return;
        }
        
        $styleId = XenForo_Application::get('options')->waindigo_adminStyles_adminStyleId;
        
        if (!is_array(self::$_data['adminStyleProperties']) || !isset(self::$_data['adminStyleProperties']['style_id']) ||
             self::$_data['adminStyleProperties']['style_id'] != $styleId) {
            $stylePropertyModel = XenForo_Model::create('XenForo_Model_StyleProperty');
            
            $propertyCache = $stylePropertyModel->rebuildPropertyCacheInStyleAndChildren($styleId);
            $propertyCache['style_id'] = $styleId;
            
            $dataRegistryModel = XenForo_Model::create('XenForo_Model_DataRegistry');
            
            $dataRegistryModel->set('adminStyleModifiedDate', XenForo_Application::$time);
            $dataRegistryModel->set('adminStyleProperties', $propertyCache);
            
            XenForo_Application::set('adminStyleProperties', $propertyCache);
        }
        
        parent::run();
    } /* END run */

    public static function initDependencies(XenForo_Dependencies_Abstract $dependencies, array $data)
    {
        $initDependencies = new Waindigo_AdminStyles_Listener_InitDependencies($dependencies, $data);
        $initDependencies->run();
    } /* END initDependencies */
}