<?php

class Waindigo_AdminStyles_Listener_TemplateCreate extends Waindigo_Listener_TemplateCreate
{

    protected function _getTemplates()
    {
        return array(
            'PAGE_CONTAINER',
            'LOGIN_PAGE'
        );
    } /* END _getTemplates */

    public static function templateCreate(&$templateName, array &$params, XenForo_Template_Abstract $template)
    {
        $templateCreate = new Waindigo_AdminStyles_Listener_TemplateCreate($templateName, $params, $template);
        list ($templateName, $params) = $templateCreate->run();
    } /* END templateCreate */

    protected function _pageContainer()
    {
        if ($this->_template instanceof XenForo_Template_Admin) {
            $this->_template->addRequiredExternal('css', 'ADMIN');
        }
    } /* END _pageContainer */

    protected function _loginPage()
    {
        $this->_pageContainer();
    } /* END _loginPage */
}