<?php

class Waindigo_AdminStyles_Option_AdminStyle
{
	/**
	 * Renders select menu allowing the selection of style.
	 *
	 * @param XenForo_View $view View object
	 * @param string $fieldPrefix Prefix for the HTML form field name
	 * @param array $preparedOption Prepared option info
	 * @param boolean $canEdit True if an "edit" link should appear
	 *
	 * @return XenForo_Template_Abstract Template object
	 */
	public static function renderOption(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
	{
		$preparedOption['formatParams'] = Waindigo_AdminStyles_Helper_AdminStyle::getStyles();
		
		return XenForo_ViewAdmin_Helper_Option::renderOptionTemplateInternal(
				'option_list_option_select',
				$view, $fieldPrefix, $preparedOption, $canEdit
		);
	} /* END renderOption */
}