<?php

/**
 * Data writer for idle users emails
 */
class Waindigo_EmailIdleUsers_DataWriter_EmailIdleUsersLog extends XenForo_DataWriter
{

    /**
     * Title of the phrase that will be created when a call to set the
     * existing data fails (when the data doesn't exist).
     *
     * @var string
     */
    protected $_existingDataErrorPhrase = 'requested_log_entry_not_found';

    /**
     * Gets the fields that are defined for the table.
     * See parent for explanation.
     *
     * @return array
     */
    protected function _getFields()
    {
        return array(
            'xf_idle_user_log' => array(
                'log_id' => array(
                    'type' => self::TYPE_UINT,
                    'autoIncrement' => true
                ),
                'log_date' => array(
                    'type' => self::TYPE_UINT,
                    'default' => XenForo_Application::$time
                ),
                'user_id' => array(
                    'type' => self::TYPE_UINT,
                    'required' => true
                ),
                'username' => array(
                    'type' => self::TYPE_STRING,
                    'required' => true,
                    'maxLength' => 50
                ),
                'content_type' => array(
                    'type' => self::TYPE_STRING,
                    'required' => true,
                    'maxLength' => 25
                ),
                'action' => array(
                    'type' => self::TYPE_STRING,
                    'required' => true,
                    'maxLength' => 25
                ),
                'action_params' => array(
                    'type' => self::TYPE_JSON,
                    'default' => ''
                )
            )
        );
    } /* END _getFields */

    /**
     * Gets the actual existing data out of data that was passed in.
     * See parent for explanation.
     *
     * @param mixed
     *
     * @return array false
     */
    protected function _getExistingData($data)
    {
        if (!$id = $this->_getExistingPrimaryKey($data)) {
            return false;
        }
        
        return array(
            'xf_idle_user_log' => $this->_getEmailIdleUsersLogModel()->getIdleUsersLogById($id)
        );
    } /* END _getExistingData */

    /**
     * Gets SQL condition to update the existing record.
     *
     * @return string
     */
    protected function _getUpdateCondition($tableName)
    {
        return 'xf_idle_user_log = ' . $this->_db->quote($this->getExisting('log_id'));
    } /* END _getUpdateCondition */

    /**
     *
     * @return EmailIdleUsersLog_Model
     */
    protected function _getEmailIdleUsersLogModel()
    {
        return $this->getModelFromCache('Waindigo_EmailIdleUsers_Model_EmailIdleUsers');
    } /* END _getEmailIdleUsersLogModel */
}