<?php

class Waindigo_EmailIdleUsers_Model_EmailIdleUsersLog extends XenForo_Model
{

    public function getIdleUsersLogById($id)
    {
        return $this->_getDb()->fetchRow(
            '
			SELECT xf_idle_user_log.*, user.username
			FROM xf_idle_user_log AS xf_idle_user_log
			INNER JOIN xf_user AS user ON (user.user_id = xf_idle_user_log.user_id)
			WHERE xf_idle_user_log.log_id = ?
		', $id);
    } /* END getIdleUsersLogById */

    public function getIdleUsersLogEntries($userId = 0, $action = '', array $fetchOptions = array())
    {
        $db = $this->_getDb();

        $limitOptions = $this->prepareLimitFetchOptions($fetchOptions);

        return $this->fetchAllKeyed(
            $this->limitQueryResults(
                '
				SELECT xf_idle_user_log.*, user.username
				FROM xf_idle_user_log AS xf_idle_user_log
				INNER JOIN xf_user AS user ON (user.user_id = xf_idle_user_log.user_id)
				WHERE ' . ($userId ? 'xf_idle_user_log.user_id = ' . $db->quote($userId) : '1=1') .
                     ($action ? ' AND xf_idle_user_log.action = ' . $db->quote($action) : '') . '
				ORDER BY xf_idle_user_log.log_date DESC
			', $limitOptions['limit'], $limitOptions['offset']),
            'log_id');
    } /* END getIdleUsersLogEntries */

    public function countIdleLogEntries($userId = 0, $action = '')
    {
        $db = $this->_getDb();

        return $db->fetchOne(
            '
			SELECT COUNT(*)
			FROM xf_idle_user_log
			WHERE ' . ($userId ? 'user_id = ' . $db->quote($userId) : '1=1') .
                 ($action ? ' AND xf_idle_user_log.action = ' . $db->quote($action) : ''));
    } /* END countIdleLogEntries */

    public static function logIdleUsersAction($contentType, $action, array $actionParams = array(), array $logUser)
    {
        return XenForo_Model::create(__CLASS__)->logIdleUsersActionLocal($contentType, $action, $actionParams, $logUser);
    } /* END logIdleUsersAction */

    public function logIdleUsersActionLocal($contentType, $action, array $actionParams = array(), array $logUser)
    {
        $handler = $this->getIdleUsersLogHandler($contentType);
        if (!$handler) {
            return false;
        }

        return $handler->log($action, $actionParams, $logUser);
    } /* END logIdleUsersActionLocal */

    public function prepareIdleUsersLogEntry(array $entry)
    {
        $handler = $this->getIdleUsersLogHandler($entry['content_type']);
        if ($handler) {
            $entry = $handler->prepareEntry($entry);
        }

        return $entry;
    } /* END prepareIdleUsersLogEntry */

    /**
     * Gets the mod log handler for a specific type of content.
     *
     * @param string $contentType
     *
     * @return UserLog_UserLogHandler_Abstract false
     */
    public function getIdleUsersLogHandler($contentType)
    {
        $handlerClass = $this->getContentTypeField($contentType, 'email_idle_users_log_handler_class');
        if (!$handlerClass) {
            return false;
        }

        return new $handlerClass();
    } /* END getIdleUsersLogHandler */

    public function prepareIdleUsersLogEntries(array $entries)
    {
        $handlers = $this->getLogHandlers();

        foreach ($entries as $key => &$entry) {
            if (isset($handlers[$entry['content_type']])) {
                $entry = $handlers[$entry['content_type']]->prepareEntry($entry);
            } else {
                unset($entries[$key]);
            }
        }

        return $entries;
    } /* END prepareIdleUsersLogEntries */

    /**
     * Gets the user log handlers for all content types.
     *
     * @return array Array of LogHandler_Abstract objects
     */
    public function getLogHandlers()
    {
        $handlerClasses = $this->getContentTypesWithField('email_idle_users_log_handler_class');
        $handlers = array();
        foreach ($handlerClasses as $contentType => $handlerClass) {
            $handlers[$contentType] = new $handlerClass();
        }

        return $handlers;
    } /* END getLogHandlers */

    public function getUsersWithLogs()
    {
        $userIds = $this->_getDb()->fetchCol('
			SELECT DISTINCT user_id
			FROM xf_idle_user_log
		');
        if (!$userIds) {
            return array();
        }

        return $this->getModelFromCache('XenForo_Model_User')->getUsersByIds($userIds);
    } /* END getUsersWithLogs */

    public function clearLog()
    {
        $this->_getDb()->query('TRUNCATE TABLE xf_idle_user_log');
    } /* END clearLog */
}