<?php

class Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade extends XenForo_ControllerHelper_Abstract
{

    protected static $_fileName = '';

    protected static $_headers = array();

    public function checkForUrl($returnBody = false)
    {
        /* @var $installUpgradeModel Waindigo_InstallUpgrade_Model_InstallUpgrade */
        $installUpgradeModel = $this->_controller->getModelFromCache('Waindigo_InstallUpgrade_Model_InstallUpgrade');

        $options = $this->_controller->getInput()->filter(
            array(
                'original_server_file' => XenForo_Input::STRING,
                'server_file' => XenForo_Input::STRING,
                'status' => XenForo_Input::UINT,
                'redirect' => XenForo_Input::STRING,
                'post_params' => XenForo_Input::ARRAY_SIMPLE,
                'username' => XenForo_Input::STRING,
                'password' => XenForo_Input::STRING,
                'auth_type' => XenForo_Input::STRING,
                'store_credentials' => XenForo_Input::UINT,
                'cookie_path' => XenForo_Input::STRING
            ));

        if (!self::$_fileName) {
            if ($options['original_server_file']) {
                self::$_fileName = $options['original_server_file'];
            } else {
                if ($options['redirect']) {
                    self::$_fileName = $options['redirect'];
                } else {
                    self::$_fileName = $options['server_file'];
                }
                $options['original_server_file'] = self::$_fileName;
            }
        }

        if ($returnBody) {
            $options['return'] = 'body';
        }

        $errorPhraseKey = '';
        $body = $installUpgradeModel->checkForUrl($options, $errorPhraseKey);

        self::$_headers = array_change_key_case($options['headers'], CASE_LOWER);

        $this->_controller->getRequest()->setParams($options);

        if ($errorPhraseKey) {
            if ($errorPhraseKey == 'do_not_have_permission') {
                throw $this->_controller->responseException($this->_controller->responseNoPermissionExternal($options));
            } else {
                throw $this->_controller->responseException(
                    $this->_controller->responseError(new XenForo_Phrase($errorPhraseKey)));
            }
        }

        return $body;
    } /* END checkForUrl */

    public static function getFileName()
    {
        return self::$_fileName;
    } /* END getFileName */

    public static function getHeaders()
    {
        return self::$_headers;
    } /* END getHeaders */
}