<?php

class Waindigo_InstallUpgrade_ControllerHelper_Xml_Smilie extends XenForo_ControllerHelper_Xml
{

    public function getXmlFromFile($file)
    {
        if ($file instanceof XenForo_Upload) {
            $file = $file->getTempFile();
        }

        /* @var $installUpgradeModel Waindigo_InstallUpgrade_Model_InstallUpgrade */
        $installUpgradeModel = XenForo_Model::create('Waindigo_InstallUpgrade_Model_InstallUpgrade');

        $file = $installUpgradeModel->extractFromFile($file, 'smilies');

        $skippedFiles = $installUpgradeModel->getSkippedFiles();
        if (!empty($skippedFiles)) {
            $viewParams['skippedFiles'] = $skippedFiles;
            throw $this->_controller->responseException(
                $this->_controller->responseView('Waindigo_InstallUpgrade_ViewPublic_Smilie_FilesSkipped',
                    'waindigo_files_skipped_smilie_installupgrade', $viewParams));
        }

        if (is_array($file)) {
            $input = $this->_controller->getInput()->filter(
                array(
                    'overwrite' => XenForo_Input::UINT
                ));
            $viewParams = array(
                'overwrite' => $input['overwrite']
            );
            throw $this->_controller->responseException(
                $this->_controller->responseView('Waindigo_InstallUpgrade_ViewPublic_Smilie_ChooseXml',
                    'waindigo_choose_xml_smilie_installupgrade', $viewParams));
        }

        return parent::getXmlFromFile($file);
    } /* END getXmlFromFile */
}