<?php

/**
 *
 * @see Waindigo_CustomFields_ControllerAdmin_ThreadField
 */
class Waindigo_InstallUpgrade_Extend_Waindigo_CustomFields_ControllerAdmin_ThreadField extends XFCP_Waindigo_InstallUpgrade_Extend_Waindigo_CustomFields_ControllerAdmin_ThreadField
{

    /**
     *
     * @see XenForo_ControllerAdmin_ThreadField::actionImport()
     */
    public function actionImport()
    {
        $fieldModel = $this->_getFieldModel();

        if ($this->isConfirmedPost()) {
            $this->_checkForChoices();
            $fileTransfer = new Zend_File_Transfer_Adapter_Http();
            if (!$fileTransfer->isUploaded('upload')) {
                /* @var $helper Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade */
                $helper = $this->getHelper('Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade');
                $helper->checkForUrl();

                $fileName = $this->_input->filterSingle('server_file', XenForo_Input::STRING);

                $input = $this->_input->filter(
                    array(
                        'target' => XenForo_Input::STRING,
                        'display_group' => XenForo_Input::STRING,
                        'overwrite_field_id' => XenForo_Input::STRING
                    ));

                if ($input['target'] == 'overwrite') {
                    $field = $this->_getFieldOrError($input['overwrite_field_id']);
                    $input['display_group'] = $field['display_group'];
                }

                $document = $this->getHelper('Xml')->getXmlFromFile($fileName);
                $caches = $fieldModel->importFieldXml($document, $input['display_group'], $input['overwrite_field_id']);

                if (XenForo_Application::$versionId < 1020000) {
                    return XenForo_CacheRebuilder_Abstract::getRebuilderResponse($this, $caches,
                        XenForo_Link::buildAdminLink('thread-fields'));
                } else {
                    return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,
                        XenForo_Link::buildAdminLink('thread-fields'));
                }
            }

            if (isset($_FILES['upload'])) {
                $files = $_FILES['upload'];
                foreach ($files['name'] as $key => $filename) {
                    $filesArrayKeys = array_keys($files);
                    $_FILES['upload'] = array();
                    foreach ($filesArrayKeys as $filesArrayKey) {
                        $_FILES['upload'][$filesArrayKey] = $files[$filesArrayKey][$key];
                    }

                    $response = parent::actionImport();

                    if ($response instanceof XenForo_ControllerResponse_View) {
                        break;
                    }
                }
            }
        }

        if (!isset($response)) {
            $response = parent::actionImport();
        }

        return $response;
    } /* END actionImport */

    protected function _checkForChoices()
    {
        $choices = $this->_input->filterSingle('choice', XenForo_Input::ARRAY_SIMPLE);
        if (!empty($choices)) {
            $viewParams = array(
                'addOnId' => $this->_input->filterSingle('addon_id', XenForo_Input::STRING),
                'choices' => $choices
            );
            throw ($this->responseException(
                $this->responseView('Waindigo_InstallUpgrade_ViewPublic_ThreadField_ChooseXml',
                    'waindigo_choose_xml_thread_field_installupgrade', $viewParams)));
        }
    } /* END _checkForChoices */

    public function responseNoPermissionExternal(array $viewParams = array())
    {
        $input = $this->_input->filter(
            array(
                'target' => XenForo_Input::STRING,
                'display_group' => XenForo_Input::STRING,
                'overwrite_field_id' => XenForo_Input::STRING
            ));
        $viewParams = array_merge($viewParams,
            array(
                'target' => $input['target'],
                'displayGroup' => $input['display_group'],
                'overwriteFieldId' => $input['overwrite_field_id']
            ));
        return $this->responseView('Waindigo_InstallUpgrade_ViewAdmin_ThreadField_Login',
            'waindigo_thread_field_login_installupgrade', $viewParams);
    } /* END responseNoPermissionExternal */

    public function getHelper($helper)
    {
        if ($helper == 'Xml') {
            $helper = 'Waindigo_InstallUpgrade_ControllerHelper_Xml_ThreadField';
        }
        return parent::getHelper($helper);
    } /* END getHelper */
}