<?php

/**
 *
 * @see XenForo_ControllerAdmin_AddOn
 */
class Waindigo_InstallUpgrade_Extend_XenForo_ControllerAdmin_AddOn extends XFCP_Waindigo_InstallUpgrade_Extend_XenForo_ControllerAdmin_AddOn
{

    /**
     * @see XenForo_ControllerAdmin_AddOn::actionIndex()
     */
    public function actionIndex()
    {
        $response = parent::actionIndex();

        if ($response instanceof XenForo_ControllerResponse_View) {
            $addOnModel = $this->_getAddOnModel();

            $response->params['addOns'] = $addOnModel->prepareAddOns($response->params['addOns']);
        }

        return $response;
    } /* END actionIndex */

    /**
     * @see XenForo_ControllerAdmin_AddOn::actionAdd()
     */
    public function actionAdd()
    {
        $response = parent::actionAdd();

        if ($response instanceof XenForo_ControllerResponse_View) {
            $xenOptions = XenForo_Application::get('options');
            if ($xenOptions->waindigo_installUpgrade_defaultVersions) {
                $response->params['addOn']['version_string'] = '1.0.0';
                $response->params['addOn']['version_id'] = XenForo_Application::$time;
            }
            if ($xenOptions->waindigo_installUpgrade_defaultWaindigoInstall) {
                $response->params['addOn']['install_callback_class'] = 'Waindigo_Install';
                $response->params['addOn']['install_callback_method'] = 'install';
                $response->params['addOn']['uninstall_callback_class'] = 'Waindigo_Install';
                $response->params['addOn']['uninstall_callback_method'] = 'uninstall';
            }
        }

        return $response;
    } /* END actionAdd */

    /**
     *
     * @see XenForo_ControllerAdmin_AddOn::actionInstall()
     */
    public function actionDelete()
    {
        if ($this->isConfirmedPost()) // delete add-on
		{
            $addOnIds = $this->_input->filterSingle('addon_ids', XenForo_Input::ARRAY_SIMPLE);

            if ($addOnIds) {
                foreach ($addOnIds as $addOnId) {
                    $this->_request->setParam('addon_id', $addOnId);

                    $response = parent::actionDelete();

                    if ($response instanceof XenForo_ControllerResponse_View) {
                        break;
                    }
                }
            }
        }

        if (!isset($response)) {
            $response = parent::actionDelete();
        }

        return $response;
    } /* END actionDelete */

    /**
     *
     * @see XenForo_ControllerAdmin_AddOn::actionInstall()
     */
    public function actionInstall()
    {
        $GLOBALS['XenForo_ControllerAdmin_AddOn'] = $this;

        if ($this->_request->isPost()) {
            $this->_checkForChoices();
            $this->_checkForUrl();

            if (isset($_FILES['upload_file'])) {
                $files = $_FILES['upload_file'];
                if (!is_array($files['name'])) {
                    return parent::actionInstall();
                }
                foreach ($files['name'] as $key => $filename) {
                    $filesArrayKeys = array_keys($files);
                    $_FILES['upload_file'] = array();
                    foreach ($filesArrayKeys as $filesArrayKey) {
                        $_FILES['upload_file'][$filesArrayKey] = $files[$filesArrayKey][$key];
                    }

                    $response = parent::actionInstall();

                    if ($response instanceof XenForo_ControllerResponse_View) {
                        break;
                    }
                }
            }
        }

        if (!isset($response)) {
            $response = parent::actionInstall();
        }

        return $response;
    } /* END actionInstall */

    /**
     *
     * @see XenForo_ControllerAdmin_AddOn::actionUpgrade()
     */
    public function actionUpgrade()
    {
        $GLOBALS['XenForo_ControllerAdmin_AddOn'] = $this;

        if ($this->_request->isPost()) {
            $addOnIds = $this->_input->filterSingle('addon_ids', XenForo_Input::ARRAY_SIMPLE);

            if ($addOnIds) {
                $addOns = $this->_getAddOnModel()->getAllAddOns();

                foreach ($addOnIds as $addOnId) {
                    if (!empty($addOns[$addOnId])) {
                        $addOn = $addOns[$addOnId];

                        $this->_request->clearParams();
                        $this->_request->setParam('addon_id', $addOnId);
                        $this->_request->setParam('server_file', $addOn['install_upgrade_filename']);

                        $this->_checkForUrl();

                        $response = parent::actionUpgrade();

                        if ($response instanceof XenForo_ControllerResponse_View) {
                            break;
                        }
                    }
                }
            } else {
                $this->_checkForChoices();
                $this->_checkForUrl();

                if (isset($_FILES['upload_file'])) {
                    $files = $_FILES['upload_file'];
                    foreach ($files['name'] as $key => $filename) {
                        $filesArrayKeys = array_keys($files);
                        $_FILES['upload_file'] = array();
                        foreach ($filesArrayKeys as $filesArrayKey) {
                            $_FILES['upload_file'][$filesArrayKey] = $files[$filesArrayKey][$key];
                        }

                        $response = parent::actionUpgrade();

                        if ($response instanceof XenForo_ControllerResponse_View) {
                            break;
                        }
                    }
                }
            }
        }

        if (!isset($response)) {
            $response = parent::actionUpgrade();
        }

        return $response;
    } /* END actionUpgrade */

    public function actionOutdated()
    {
        $addOnModel = $this->_getAddOnModel();
        $addOns = $addOnModel->getAllAddOns();

        $installUpgradeModel = $this->getModelFromCache('Waindigo_InstallUpgrade_Model_InstallUpgrade');
        $checked = $installUpgradeModel->checkForAddOnUpdates($addOns, $errorString);

        foreach ($addOns as $addOnId => $addOn) {
            if (!$addOn['install_upgrade_updated']) {
                unset($addOns[$addOnId]);
            }
        }

        $addOns = $addOnModel->prepareAddOns($addOns);

        $viewParams = array(
            'addOns' => $addOns,
            'errorString' => $errorString
        );

        return $this->responseView('Waindigo_InstallUpgrade_ViewAdmin_AddOn_Outdated',
            'waindigo_outdated_addons_installupgrade', $viewParams);
    } /* END actionOutdated */

    protected function _checkForChoices()
    {
        $choices = $this->_input->filterSingle('choice', XenForo_Input::ARRAY_SIMPLE);
        if (!empty($choices)) {
            $viewParams = array(
                'addOnId' => $this->_input->filterSingle('addon_id', XenForo_Input::STRING),
                'choices' => $choices
            );
            throw ($this->responseException(
                $this->responseView('Waindigo_InstallUpgrade_ViewPublic_AddOn_ChooseXml',
                    'waindigo_choose_xml_addon_installupgrade', $viewParams)));
        }
    } /* END _checkForChoices */

    protected function _checkForUrl()
    {
        /* @var $helper Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade */
        $helper = $this->getHelper('Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade');
        $helper->checkForUrl();
    } /* END _checkForUrl */

    public function actionRebuildCaches()
    {
        XenForo_Application::get('options')->set('waindigo_installUpgrade_noAddOnCacheRebuild', false);

        $caches = $this->_getAddOnModel()->rebuildAddOnCaches();

        if (XenForo_Application::$versionId < 1020000) {
            return XenForo_CacheRebuilder_Abstract::getRebuilderResponse($this, $caches,
                XenForo_Link::buildAdminLink('add-ons'));
        }

        return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,
            $this->getDynamicRedirect(XenForo_Link::buildAdminLink('add-ons'), true));
    } /* END actionRebuildCaches */

    public function actionRebuild()
    {
        $addOnId = $this->_input->filterSingle('addon_id', XenForo_Input::STRING);
        Waindigo_Install::install(array(), array(
            'addon_id' => $addOnId
        ));

        $caches = $this->_getAddOnModel()->rebuildAddOnCaches();

        return XenForo_CacheRebuilder_Abstract::getRebuilderResponse($this, $caches,
            XenForo_Link::buildAdminLink('add-ons'));
    } /* END actionRebuild */

    public function actionDownload()
    {
        $this->assertDebugMode();

        $addOnId = $this->_input->filterSingle('addon_id', XenForo_Input::STRING);
        $addOn = $this->_getAddOnModel()->getAddOnById($addOnId);
        if (!$addOn) {
            $addOn = array(
                'addon_id' => $addOnId
            );
        }

        if ($this->isConfirmedPost()) { // download add-on
            $versionString = $this->_input->filterSingle('version_string',
                XenForo_Input::STRING);
            $noCopyright = false;
            if (XenForo_Application::getOptions()->waindigo_installUpgrade_copyrightVisibility) {
                $noCopyright = $this->_input->filterSingle('no_copyright', XenForo_Input::UINT);
            }
            $GLOBALS['XenForo_ControllerAdmin_AddOn'] = $this;
            $zipFile = $this->_getAddOnModel()->prepareAddOnForDownload($addOn, $versionString, $noCopyright);

            $addOn['version_string'] = $versionString;

            $this->_routeMatch->setResponseType('raw');

            $viewParams = array(
                'addOn' => $addOn,
                'zipFile' => $zipFile
            );

            return $this->responseView('Waindigo_InstallUpgrade_ViewAdmin_AddOn_Download', '', $viewParams);
        } else {
            if (!isset($addOn['title'])) {
                $addOnXML = new SimpleXMLElement(
                    file_get_contents(
                        XenForo_Application::getInstance()->getRootDir() . '/install/data/addon-' . $addOn['addon_id'] .
                             '.xml'));
                $addOn['title'] = (string) $addOnXML->attributes()->title;
                $addOn['version_string'] = (string) $addOnXML->attributes()->version_string;
            }
            $viewParams = array(
                'addOn' => $addOn
            );

            return $this->responseView('Waindigo_InstallUpgrade_ViewAdmin_AddOn_Download',
                'waindigo_addon_download_installupgrade', $viewParams);
        }
    } /* END actionDownload */

    public function responseNoPermissionExternal(array $viewParams = array())
    {
        $addOnId = $this->_input->filterSingle('addon_id', XenForo_Input::STRING);
        if ($addOnId) {
            $viewParams['addOn'] = array(
                'addon_id' => $addOnId
            );
        }

        return $this->responseView('Waindigo_InstallUpgrade_ViewAdmin_AddOn_Login',
            'waindigo_addon_login_installupgrade', $viewParams);
    } /* END responseNoPermissionExternal */
}