<?php

/**
 *
 * @see XenForo_ControllerAdmin_Style
 */
class Waindigo_InstallUpgrade_Extend_XenForo_ControllerAdmin_Style extends XFCP_Waindigo_InstallUpgrade_Extend_XenForo_ControllerAdmin_Style
{

    /**
     *
     * @see XenForo_ControllerAdmin_Style::actionImport()
     */
    public function actionImport()
    {
        $styleModel = $this->_getStyleModel();

        if ($this->isConfirmedPost()) {
            $this->_checkForChoices();
            $fileTransfer = new Zend_File_Transfer_Adapter_Http();
            if (!$fileTransfer->isUploaded('upload')) {
                /* @var $helper Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade */
                $helper = $this->getHelper('Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade');
                $helper->checkForUrl();

                $fileName = $this->_input->filterSingle('server_file', XenForo_Input::STRING);

                $input = $this->_input->filter(
                    array(
                        'target' => XenForo_Input::STRING,
                        'parent_style_id' => XenForo_Input::UINT,
                        'overwrite_style_id' => XenForo_Input::UINT
                    ));

                if ($input['target'] == 'overwrite') {
                    $this->_getStyleOrError($input['overwrite_style_id']);
                    $input['parent_style_id'] = 0;
                } else {
                    $input['overwrite_style_id'] = 0;
                }

                $document = $this->getHelper('Xml')->getXmlFromFile($fileName);
                $caches = $styleModel->importStyleXml($document, $input['parent_style_id'],
                    $input['overwrite_style_id']);

                if (XenForo_Application::$versionId < 1020000) {
                    return XenForo_CacheRebuilder_Abstract::getRebuilderResponse($this, $caches,
                        XenForo_Link::buildAdminLink('styles'));
                } else {
                    return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,
                        XenForo_Link::buildAdminLink('styles'));
                }
            }

            if (isset($_FILES['upload'])) {
                $files = $_FILES['upload'];
                foreach ($files['name'] as $key => $filename) {
                    $filesArrayKeys = array_keys($files);
                    $_FILES['upload'] = array();
                    foreach ($filesArrayKeys as $filesArrayKey) {
                        $_FILES['upload'][$filesArrayKey] = $files[$filesArrayKey][$key];
                    }

                    $response = parent::actionImport();

                    if ($response instanceof XenForo_ControllerResponse_View) {
                        break;
                    }
                }
            }
        }

        if (!isset($response)) {
            $response = parent::actionImport();
        }

        return $response;
    } /* END actionImport */

    protected function _checkForChoices()
    {
        $choices = $this->_input->filterSingle('choice', XenForo_Input::ARRAY_SIMPLE);
        if (!empty($choices)) {
            $viewParams = array(
                'addOnId' => $this->_input->filterSingle('addon_id', XenForo_Input::STRING),
                'choices' => $choices
            );
            throw ($this->responseException(
                $this->responseView('Waindigo_InstallUpgrade_ViewPublic_Style_ChooseXml',
                    'waindigo_choose_xml_style_installupgrade', $viewParams)));
        }
    } /* END _checkForChoices */

    public function responseNoPermissionExternal(array $viewParams = array())
    {
        $input = $this->_input->filter(
            array(
                'target' => XenForo_Input::STRING,
                'parent_style_id' => XenForo_Input::UINT,
                'overwrite_style_id' => XenForo_Input::UINT
            ));
        $viewParams = array_merge($viewParams,
            array(
                'target' => $input['target'],
                'parentStyleId' => $input['parent_style_id'],
                'overwriteStyleId' => $input['overwrite_style_id']
            ));
        return $this->responseView('Waindigo_InstallUpgrade_ViewAdmin_Style_Login',
            'waindigo_style_login_installupgrade', $viewParams);
    } /* END responseNoPermissionExternal */

    public function getHelper($helper)
    {
        if ($helper == 'Xml') {
            $helper = 'Waindigo_InstallUpgrade_ControllerHelper_Xml_Style';
        }
        return parent::getHelper($helper);
    } /* END getHelper */
}