<?php

/**
 *
 * @see XenForo_ControllerAdmin_TemplateModification
 */
class Waindigo_InstallUpgrade_Extend_XenForo_ControllerAdmin_TemplateModification extends XFCP_Waindigo_InstallUpgrade_Extend_XenForo_ControllerAdmin_TemplateModification
{

    /**
     *
     * @see XenForo_ControllerAdmin_TemplateModification::actionIndex()
     */
    public function actionIndex()
    {
        $response = parent::actionIndex();

        if ($response instanceof XenForo_ControllerResponse_View) {
            foreach ($response->params['groupedModifications'] as $addOnId => $modifications) {
                foreach ($modifications as $modificationId => $modification) {
                    if (preg_match('#^waindigo_copyrightNotice_#', $modification['modification_key'])) {
                        unset($response->params['groupedModifications'][$addOnId][$modificationId]);
                    }
                }
            }

            $response->params['groupedModifications'] = array_filter($response->params['groupedModifications']);
        }

        return $response;
    } /* END actionIndex */

    /**
     *
     * @see XenForo_ControllerAdmin_TemplateModification::_getModificationAddEditResponse()
     */
    protected function _getModificationAddEditResponse(array $modification)
    {
        if (isset($modification['modification_key'])) {
            if (preg_match('#^waindigo_copyrightNotice_#', $modification['modification_key'])) {
                return $this->responseNoPermission();
            }
        }

        return parent::_getModificationAddEditResponse($modification);
    } /* END _getModificationAddEditResponse */

    /**
     *
     * @see XenForo_ControllerAdmin_TemplateModification::actionSave()
     */
    public function actionSave()
    {
        $modificationKey = $this->_input->filterSingle('modification_key', XenForo_Input::STRING);

        if (preg_match('#^waindigo_copyrightNotice_#', $modificationKey)) {
            return $this->responseNoPermission();
        }

        return parent::actionSave();
    } /* END actionSave */
}