<?php

/**
 *
 * @see XenForo_ControllerAdmin_UserGroup
 */
class Waindigo_InstallUpgrade_Extend_XenForo_ControllerAdmin_UserGroup extends XFCP_Waindigo_InstallUpgrade_Extend_XenForo_ControllerAdmin_UserGroup
{

    /**
     *
     * @see XenForo_ControllerAdmin_UserGroup::actionImport()
     */
    public function actionImport()
    {
        $groupModel = $this->_getUserGroupModel();

        if ($this->isConfirmedPost()) {
            $this->_checkForChoices();
            $fileTransfer = new Zend_File_Transfer_Adapter_Http();
            if (!$fileTransfer->isUploaded('upload')) {
                /* @var $helper Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade */
                $helper = $this->getHelper('Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade');
                $helper->checkForUrl();

                $fileName = $this->_input->filterSingle('server_file', XenForo_Input::STRING);

                $input = $this->_input->filter(
                    array(
                        'target' => XenForo_Input::STRING,
                        'overwrite_user_group_id' => XenForo_Input::UINT
                    ));

                if ($input['target'] == 'overwrite') {
                    $this->_getUserGroupOrError($input['overwrite_user_group_id']);
                } else {
                    $input['overwrite_user_group_id'] = 0;
                }

                $document = $this->getHelper('Xml')->getXmlFromFile($fileName);
                $caches = $groupModel->importGroupXml($document, $input['overwrite_user_group_id']);

                if (XenForo_Application::$versionId < 1020000) {
                    return XenForo_CacheRebuilder_Abstract::getRebuilderResponse($this, $caches,
                        XenForo_Link::buildAdminLink('user-groups'));
                } else {
                    return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,
                        XenForo_Link::buildAdminLink('user-groups'));
                }
            }

            if (isset($_FILES['upload'])) {
                $files = $_FILES['upload'];
                foreach ($files['name'] as $key => $filename) {
                    $filesArrayKeys = array_keys($files);
                    $_FILES['upload'] = array();
                    foreach ($filesArrayKeys as $filesArrayKey) {
                        $_FILES['upload'][$filesArrayKey] = $files[$filesArrayKey][$key];
                    }

                    $response = parent::actionImport();

                    if ($response instanceof XenForo_ControllerResponse_View) {
                        break;
                    }
                }
            }
        }

        if (!isset($response)) {
            $response = parent::actionImport();
        }

        return $response;
    } /* END actionImport */

    protected function _checkForChoices()
    {
        $choices = $this->_input->filterSingle('choice', XenForo_Input::ARRAY_SIMPLE);
        if (!empty($choices)) {
            $viewParams = array(
                'addOnId' => $this->_input->filterSingle('addon_id', XenForo_Input::STRING),
                'choices' => $choices
            );
            throw ($this->responseException(
                $this->responseView('Waindigo_InstallUpgrade_ViewPublic_UserGroup_ChooseXml',
                    'waindigo_choose_xml_user_group_installupgrade', $viewParams)));
        }
    } /* END _checkForChoices */

    public function responseNoPermissionExternal(array $viewParams = array())
    {
        $input = $this->_input->filter(
            array(
                'target' => XenForo_Input::STRING,
                'overwrite_user_group_id' => XenForo_Input::UINT
            ));
        $viewParams = array_merge($viewParams,
            array(
                'target' => $input['target'],
                'overwriteUserGroupId' => $input['overwrite_user_group_id']
            ));
        return $this->responseView('Waindigo_InstallUpgrade_ViewAdmin_UserGroup_Login',
            'waindigo_user_group_login_installupgrade', $viewParams);
    } /* END responseNoPermissionExternal */

    public function getHelper($helper)
    {
        if ($helper == 'Xml') {
            $helper = 'Waindigo_InstallUpgrade_ControllerHelper_Xml_UserGroup';
        }
        return parent::getHelper($helper);
    } /* END getHelper */
}