<?php

/**
 *
 * @see XenForo_DataWriter_AddOn
 */
class Waindigo_InstallUpgrade_Extend_XenForo_DataWriter_AddOn extends XFCP_Waindigo_InstallUpgrade_Extend_XenForo_DataWriter_AddOn
{

    /**
     *
     * @see XenForo_DataWriter_AddOn::_getFields()
     */
    protected function _getFields()
    {
        $fields = parent::_getFields();
        $fields['xf_addon']['install_upgrade_filename'] = array(
            'type' => self::TYPE_STRING,
            'default' => ''
        );
        $fields['xf_addon']['install_upgrade_headers'] = array(
            'type' => self::TYPE_SERIALIZED,
            'default' => ''
        );
        $fields['xf_addon']['install_upgrade_updated'] = array(
            'type' => self::TYPE_UINT,
            'default' => 0
        );

        return $fields;
    } /* END _getFields */

    /**
     *
     * @see XenForo_DataWriter_AddOn::_preSave()
     */
    protected function _preSave()
    {
        $fileName = Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade::getFileName();

        if ($fileName) {
            $this->set('install_upgrade_filename', $fileName);
        }

        $headers = Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade::getHeaders();

        if ($headers) {
            $this->set('install_upgrade_headers', $headers);
            $this->set('install_upgrade_updated', 0);
        }

        parent::_preSave();
    } /* END _preSave */

    /**
     *
     * @see XenForo_DataWriter_AddOn::_postSave()
     */
    protected function _postSave()
    {
        if (!empty($GLOBALS['XenForo_ControllerAdmin_AddOn'])) {
            /* @var $controller XenForo_ControllerAdmin_AddOn */
            $controller = $GLOBALS['XenForo_ControllerAdmin_AddOn'];

            if ($this->isInsert() && strtolower($controller->getRouteMatch()->getAction()) == 'save' && ($this->get(
                'install_callback_class') == 'Waindigo_Install' ||
                 $this->get('uninstall_callback_class') == 'Waindigo_Install')) {
                $class = $this->get('addon_id') . '_Install_Controller';
                $filename = XenForo_Autoloader::getInstance()->getRootDir() . "/" . str_replace("_", "/", $class) .
                     ".php";
                if (!file_exists($filename)) {
                    $phpFile = new Waindigo_InstallUpgrade_PhpFile_Install_Controller($class);
                    $phpFile->export(true);
                }
            }
        }

        if (XenForo_Application::$versionId > 1020000) {
            XenForo_Application::defer('Waindigo_InstallUpgrade_Deferred_UpdateCheck', array(), 'WaindigoIuUpdateCheck');
        }

        parent::_postSave();
    } /* END _postSave */
}