<?php

/**
 *
 * @see XenForo_Model_AddOn
 */
class Waindigo_InstallUpgrade_Extend_XenForo_Model_AddOn extends XFCP_Waindigo_InstallUpgrade_Extend_XenForo_Model_AddOn
{

    public function prepareAddOn(array $addOn)
    {
        if (!empty($addOn['install_upgrade_filename'])) {
            if (filter_var($addOn['install_upgrade_filename'], FILTER_VALIDATE_URL) !== FALSE) {
                $addOn['canUpgrade'] = true;
            }
        }

        return $addOn;
    }

    public function prepareAddOns(array $addOns)
    {
        foreach ($addOns as &$addOn) {
            $addOn = $this->prepareAddOn($addOn);
        }

        return $addOns;
    } /* END prepareAddOns */ /* END prepareAddOns */ /* END prepareAddOns */ /* END prepareAddOns */ /* END prepareAddOns */ /* END prepareAddOns */ /* END prepareAddOns */

    /**
     *
     * @see XenForo_Model_AddOn::installAddOnXmlFromFile()
     */
    public function installAddOnXmlFromFile($fileName, $upgradeAddOnId = false)
    {
        /* @var $installUpgradeModel Waindigo_InstallUpgrade_Model_InstallUpgrade */
        $installUpgradeModel = XenForo_Model::create('Waindigo_InstallUpgrade_Model_InstallUpgrade');

        $fileName = $installUpgradeModel->extractFromFile($fileName, 'addon');

        if (isset($GLOBALS['XenForo_ControllerAdmin_AddOn'])) {
            /* @var $controller XenForo_ControllerAdmin_AddOn */
            $controller = $GLOBALS['XenForo_ControllerAdmin_AddOn'];
            $viewParams = array(
                'addOnId' => $controller->getInput()->filterSingle('addon_id', XenForo_Input::STRING),
                'choices' => $fileName
            );

            $skippedFiles = $installUpgradeModel->getSkippedFiles();
            if (!empty($skippedFiles)) {
                $viewParams['skippedFiles'] = $skippedFiles;
                throw $controller->responseException(
                    $controller->responseView('Waindigo_InstallUpgrade_ViewPublic_AddOn_FilesSkipped',
                        'waindigo_files_skipped_addon_installupgrade', $viewParams));
            }

            if (is_array($fileName)) {
                throw $controller->responseException(
                    $controller->responseView('Waindigo_InstallUpgrade_ViewPublic_AddOn_ChooseXml',
                        'waindigo_choose_xml_addon_installupgrade', $viewParams));
            }
        }

        return parent::installAddOnXmlFromFile($fileName, $upgradeAddOnId);
    } /* END installAddOnXmlFromFile */ /* END installAddOnXmlFromFile */

    /**
     *
     * @see XenForo_Model_AddOn::installAddOnXml()
     */
    public function installAddOnXml(SimpleXMLElement $xml, $upgradeAddOnId = false)
    {
        /* @var $addOnModel XenForo_Model_AddOn */
        $addOnModel = $this->getModelFromCache('XenForo_Model_AddOn');

        if ($upgradeAddOnId === false && XenForo_Application::get('options')->waindigo_installUpgrade_upgradeFromInstall) {
            $addOnId = (string) $xml['addon_id'];
            if ($addOnId) {
                $addOn = $addOnModel->getAddOnById($addOnId);
                if ($addOn) {
                    $upgradeAddOnId = $addOnId;
                }
            }
        }

        return parent::installAddOnXml($xml, $upgradeAddOnId);
    } /* END installAddOnXml */ /* END installAddOnXml */

    /**
     *
     * @see XenForo_Model_AddOn::rebuildAddOnCaches()
     */
    public function rebuildAddOnCaches()
    {
        if (XenForo_Application::get('options')->waindigo_installUpgrade_noAddOnCacheRebuild) {
            $this->getModelFromCache('XenForo_Model_CodeEvent')->rebuildEventListenerCache();
            if (XenForo_Application::$versionId < 1020000) {
                return array();
            } else {
                return;
            }
        }

        return parent::rebuildAddOnCaches();
    } /* END rebuildAddOnCaches */ /* END rebuildAddOnCaches */

    public function prepareAddOnForDownload(array $addOn, $versionString = '', $noCopyright = false)
    {
        if (!$versionString && isset($addOn['version_string'])) {
            $versionString = $addOn['version_string'];
        }

        if (isset($addOn['title']) && !XenForo_Application::get('options')->get('boardActive')) {
            throw new XenForo_Exception('Installed add-ons cannot be downloaded while forum is closed.');
        }

        /* @var $zipArchiveModel Waindigo_InstallUpgrade_Model_ZipArchive */
        $zipArchiveModel = XenForo_Model::create('Waindigo_InstallUpgrade_Model_ZipArchive');

        if (isset($addOn['title'])) {
            $this->addCopyrightNotice($addOn);
        }

        $addOnParts = explode('_', $addOn['addon_id'], 2);
        if (count($addOnParts) != 2) {
            throw new XenForo_Exception(
                'Add-on ID must have two parts to use the download function (e.g. Waindigo_InstallUpgrade).');
        }
        list($developer, $entry) = $addOnParts;

        $entry = str_replace('_', '/', $entry);

        $rootDir = XenForo_Application::getInstance()->getRootDir();
        $libraryDir = XenForo_Autoloader::getInstance()->getRootDir();

        $files['file']['upload/library/' . $developer . '/' . $entry] = $libraryDir . '/' . $developer . '/' . $entry;

        $this->_addSharedFilesToGroupedAddOns($developer, $entry, $files);

        $versionId = XenForo_Application::$time;
        $xml = $this->_getAddOnXml($addOn, $versionString, $versionId, $noCopyright);

        $files['fromString']['addon-' . $addOn['addon_id'] . '.xml'] = $xml;
        $files['fromString']['upload/install/data/addon-' . $addOn['addon_id'] . '.xml'] = $xml;

        $this->_addAddOnFiles($developer, $entry, $files);

        $exclude = 'library/' . $developer . '/' . $entry . '/Listener/FileHealthCheck.php';
        if (file_exists($rootDir . '/' . $exclude)) {
            $controller = $GLOBALS['XenForo_ControllerAdmin_AddOn'];
            $hashes = array();
            call_user_func_array($developer . '_' . $entry . '_Listener_FileHealthCheck::FileHealthCheck',
                array(
                    $controller,
                    &$hashes
                ));
            foreach ($hashes as $filename => $hash) {
                if (file_exists($filename) && !isset($files['file']['upload/' . $filename]) &&
                     !isset($files['fromString']['upload/' . $filename])) {
                    $files['file']['upload/' . $filename] = $rootDir . '/' . $filename;
                }
            }
            $hashes = self::_getHashes($files, array(
                $exclude
            ));
            $hashesList = '';
            foreach ($hashes as $filename => $hash) {
                $hashesList .= "\n" . '                \'' . $filename . '\' => \'' . $hash . '\',';
            }
            file_put_contents($rootDir . '/' . $exclude,
                '<?php

class ' . $addOn['addon_id'] . '_Listener_FileHealthCheck
{

    public static function fileHealthCheck(XenForo_ControllerAdmin_Abstract $controller, array &$hashes)
    {
        $hashes = array_merge($hashes,
            array(' . $hashesList . '
            ));
  ' . '  } /* END fileHealthCheck */
}');
            $files['file']['upload/' . $exclude] = $rootDir . '/' . $exclude;
        }

        $temp = tempnam(XenForo_Helper_File::getTempDir(), $addOn['addon_id']);

        $mostRecentUpdate = $zipArchiveModel->createZipWithFiles($files, $temp, true);

        if (isset($versionId) && $versionId > $mostRecentUpdate) {
            $mostRecentUpdate = $versionId;
        }

        $zipContents = file_get_contents($temp);
        unlink($temp);

        return array(
            'last_modified' => $mostRecentUpdate,
            'contents' => $zipContents
        );
    } /* END prepareAddOnForDownload */ /* END prepareAddOnForDownload */

    protected function _addSharedFilesToGroupedAddons($developer, $entry, array &$files)
    {
        $libraryDir = XenForo_Autoloader::getInstance()->getRootDir();

        if (strpos($entry, '/') !== false) {
            $entryParts = explode('/', $entry);
            $newEntry = '';
            foreach ($entryParts as $entryPart) {
                $newEntry .= $entryPart . '/';
                if (is_dir($libraryDir . '/' . $developer . '/' . $newEntry . 'Shared')) {
                    $files['file']['upload/library/' . $developer . '/' . $newEntry . 'Shared'] = $libraryDir . '/' .
                         $developer . '/' . $newEntry . 'Shared';
                }
            }
        }
    } /* END _addSharedFilesToGroupedAddons */

    protected function _getAddOnXml(array $addOn, $versionString, $versionId, $noCopyright)
    {
        $rootDir = XenForo_Application::getInstance()->getRootDir();
        $libraryDir = XenForo_Autoloader::getInstance()->getRootDir();

        $destination = $rootDir . '/install/data/';

        $xmlFileName = 'addon-' . $addOn['addon_id'] . '.xml';

        if (file_exists($destination . $xmlFileName)) {
            $xml = file_get_contents($destination . $xmlFileName);
            $existingAddOnXML = new SimpleXMLElement(file_get_contents($destination . $xmlFileName));
        }

        if (isset($addOn['title'])) {
            if (isset($existingAddOnXML)) {
                if ($existingAddOnXML->classes || $existingAddOnXML->object_fields) {
                    if (!Waindigo_Listener_ControllerPreDispatch::isAddOnEnabled('Waindigo_Objects')) {
                        throw new XenForo_Exception(
                            'Objects by Waindigo must be installed/enabled to download this add-on.');
                    } elseif (!Waindigo_Listener_ControllerPreDispatch::isAddOnEnabled(
                            'Waindigo_ObjectFields')) {
                            throw new XenForo_Exception(
                                'Object Fields by Waindigo must be installed/enabled to download this add-on.');
                        }
                }

                if ($existingAddOnXML->user_fields || $existingAddOnXML->thread_fields || $existingAddOnXML->post_fields) {
                    if (!Waindigo_Listener_ControllerPreDispatch::isAddOnEnabled('Waindigo_CustomFields')) {
                        throw new XenForo_Exception(
                            'Custom Fields by Waindigo must be installed/enabled to download this add-on.');
                    }
                }
            }

            $xml = $this->getAddOnXml($addOn)->saveXML();
            $addOnXML = new SimpleXMLElement($xml);
            if ($addOnXML && isset($addOnXML->templates)) {
                foreach ($addOnXML->templates->template as $template) {
                    if (pathinfo(strval($template['title']), PATHINFO_EXTENSION) == 'svg') {
                        $files['file'] = array_merge($files['file'],
                            self::_getSharedFile($libraryDir . '/Waindigo/', "SvgOutput"));
                        $files['file']['upload/svg.php'] = $rootDir . '/svg.php';
                    }
                }
            }

            $versionId = $addOn['version_id'];
            if (!file_exists($destination . $xmlFileName) || md5($xml) != md5_file($destination . $xmlFileName)) {
                $noXml = false;
                if (file_exists($destination . $xmlFileName)) {
                    $addOnXML = $existingAddOnXML;
                    $versionId = (string) $addOnXML->attributes()->version_id;
                    if ($versionId > $addOn['version_id']) {
                        $noXml = true;
                    }
                }
                if (!$noXml) {
                    /* @var $dw XenForo_DataWriter_AddOn */
                    $dw = XenForo_DataWriter::create('XenForo_DataWriter_AddOn');
                    $dw->setExistingData($addOn['addon_id']);
                    $dw->set('version_id', XenForo_Application::$time);
                    $dw->save();
                    $addOn = $dw->getMergedData();
                    $xml = $this->getAddOnXml($addOn)->saveXML();
                    file_put_contents($destination . $xmlFileName, $xml);
                }
            }
        } elseif (!isset($xml)) {
            throw new XenForo_Exception('Add-on not found.');
        }

        $addOnXML = new SimpleXMLElement($xml);
        if ($versionString && $versionString != (string) $addOnXML->attributes()->version_string) {
            $addOnXML->attributes()->version_string = $versionString;
        }
        $versionId = $addOnXML->attributes()->version_id;

        if ($noCopyright) {
            $key = $this->_getCopyrightModificationKey($addOn);
            foreach ($addOnXML->public_template_modifications->modification as $modification) {
                /* @var $modification SimpleXMLElement */
                if ($modification->attributes()->modification_key == $key) {
                    $modification->replace[0] = '';
                    $node = dom_import_simplexml($modification->replace[0]);
                    $no = $node->ownerDocument;
                    $node->appendChild(
                        $no->createCDATASection('Waindigo_Listener_InitDependencies::removeCopyrightNotice'));
                }
            }
        }

        $this->makeCompatibilitySwitches($addOnXML);
        return $addOnXML->saveXML();
    } /* END _getAddOnXml */

    protected function _addAddOnFiles($developer, $entry, array &$files)
    {
        $rootDir = XenForo_Application::getInstance()->getRootDir();
        $libraryDir = XenForo_Autoloader::getInstance()->getRootDir();

        $files['file']['LICENSE.txt'] = $libraryDir . '/LICENSE.txt';
        $files['fromString']['README.txt'] = 'Thank you for downloading this add-on by Waindigo.

To install this add-on, you will need to extract the zip and upload all the
files from the contained upload directory onto your web server into the root
folder of your XenForo Directory.

Having uploaded the necessary files, you should log in to the Admin Control
Panel of your XenForo Installation and click on \'Install Add-on\' under the
heading \'Add-ons\' on the left-hand side of the Admin Control Panel under the
\'Home\' tab.

Enter the following into the text box labelled \'Install from file on server\':
install/data/addon-' . $developer . '_' . $entry . '.xml

Alternatively, extract the zip to a folder on your local computer, and then
click \'Choose File\' to locate the extracted XML file on your computer.

UPGRADING
---------

To upgrade an existing add-on, you will need to extract the zip and upload all
files within the upload directory to your existing XenForo Directory,
overwriting all files.

Once the files are uploaded, your XenForo installation will automatically be
closed until the upgrade is complete. To begin the upgrade, log in to the Admin
Control Panel, where you will see a notice indicating that there are new
add-ons ready to be upgraded. Click the notice to upgrade your add-on.

Once the upgrade is complete, your XenForo installation will automatically be
reopened.

Note: the notice will not appear if you are upgrading to a fourth-point (x.x.xX)
version of the same release (i.e., from 1.1.2 to 1.1.2b) as upgrading the
database is not required.';

        if (file_exists($libraryDir . '/' . $developer . '/' . $entry . ".php")) {
            $files['file']['upload/library/' . $developer . '/' . $entry . ".php"] = $libraryDir . '/' . $developer . '/' .
                 $entry . ".php";
        }

        if (file_exists($libraryDir . '/' . $developer . '/' . $entry . "/Install.php") || file_exists(
            $libraryDir . '/' . $developer . '/' . $entry . "/Install/Controller.php")) {
            $files['file'] = array_merge($files['file'], self::_getSharedFile($libraryDir . '/Waindigo', "Install"));
            $files['file'] = array_merge($files['file'], self::_getSharedFile($libraryDir . '/Waindigo', "Deferred"));
        }

        $fileName = $libraryDir . '/' . $developer . '/' . $entry . '/style-' . $developer . '_' . $entry . '.xml';
        if (file_exists($fileName)) {
            $files['file']['style-' . $developer . '_' . $entry . '.xml'] = $libraryDir . '/' . $developer . '/' . $entry .
                 '/style-' . $developer . '_' . $entry . '.xml';
        }

        $files['file'] = array_merge($files['file'],
            self::_getSharedFile($libraryDir . '/Waindigo', "Listener/ControllerPreDispatch"));
        $files['file'] = array_merge($files['file'],
            self::_getSharedFile($libraryDir . '/Waindigo', "Listener/InitDependencies"));
        if (is_dir($libraryDir . '/' . $developer . '/' . $entry . "/Listener/") && $handle = opendir(
            $libraryDir . '/' . $developer . '/' . $entry . "/Listener/")) {
            while (false !== ($listenerEntry = readdir($handle))) {
                if ($listenerEntry == "FrontControllerPreView.php") {
                    $files['file'] = array_merge($files['file'],
                        self::_getSharedFile($libraryDir . '/Waindigo', "Listener/FrontControllerPreView"));
                }
                if ($listenerEntry == "NavigationTabs.php") {
                    $files['file'] = array_merge($files['file'],
                        self::_getSharedFile($libraryDir . '/Waindigo', "Listener/NavigationTabs"));
                }
                if ($listenerEntry == "VisitorSetup.php") {
                    $files['file'] = array_merge($files['file'],
                        self::_getSharedFile($libraryDir . '/Waindigo', "Listener/VisitorSetup"));
                }
                if (strlen($listenerEntry) > 9 and substr($listenerEntry, 0, 9) == "LoadClass") {
                    $files['file'] = array_merge($files['file'],
                        self::_getSharedFile($libraryDir . '/Waindigo', "Listener/LoadClass"));
                } elseif ((strlen($listenerEntry) > 8 && substr($listenerEntry, 0, 8) == "Template") ||
                     (strlen($listenerEntry) > 23 && substr($listenerEntry, 0, 23) == "FrontControllerPostView")) {
                    if (file_exists($libraryDir . '/Waindigo/Listener/' . pathinfo($listenerEntry, PATHINFO_FILENAME))) {
                        $files['file'] = array_merge($files['file'],
                            self::_getSharedFile($libraryDir . '/Waindigo', "Listener/Template"));
                        $files['file'] = array_merge($files['file'],
                            self::_getSharedFile($libraryDir . '/Waindigo',
                                "Listener/" . pathinfo($listenerEntry, PATHINFO_FILENAME)));
                    }
                }
            }
        }

        if (is_dir($rootDir . '/js/' . strtolower($developer) . '/' . strtolower($entry))) {
            $files['file']['upload/js/' . strtolower($developer) . '/index.html'] = $rootDir . '/js/' .
                 strtolower($developer) . '/index.html';
            $files['file']['upload/js/' . strtolower($developer) . '/' . strtolower($entry)] = $rootDir . '/js/' .
                 strtolower($developer) . '/' . strtolower($entry);

            Waindigo_InstallUpgrade_Helper_File::processJsFiles(
                $rootDir . '/js/' . strtolower($developer) . '/' . strtolower($entry));
        }

        $dirName = $rootDir . '/styles/default/' . strtolower($developer) . '/' . strtolower($entry);
        if (is_dir($dirName)) {
            $files['file']['upload/styles/default/' . strtolower($developer) . '/' . strtolower($entry)] = $rootDir .
                 '/styles/default/' . strtolower($developer) . '/' . strtolower($entry);
        }

        if (isset($files['file'])) {
            Waindigo_InstallUpgrade_Helper_File::processFiles($files['file']);
        }
    } /* END _addAddOnFiles */

    protected static function _getHashes(array $files, $exclude)
    {
        $fileHashes = array();
        $fileExtensions = array(
            '.php'
        );
        foreach ($files['file'] as $outputFileName => $inputFileName) {
            $filePath = substr($outputFileName, strlen('upload/'));
            if (is_dir($filePath)) {
                $fileHashes = array_merge($fileHashes,
                    XenForo_Helper_Hash::hashDirectory($filePath, $fileExtensions, $exclude));
            } else
                if (in_array(strrchr($filePath, '.'), $fileExtensions)) {
                    $fileHashes[$filePath] = XenForo_Helper_Hash::getFileContentsHash(file_get_contents($filePath));
                }
        }
        return $fileHashes;
    } /* END _getHashes */

    protected static function _getSharedFile($filePath, $sharedFile)
    {
        $sharedFiles = array();
        $version = 0;
        if ($handle = opendir($filePath . '/' . $sharedFile)) {
            while (false !== ($entry = readdir($handle))) {
                if (intval($entry) > $version)
                    $version = intval($entry);
            }
        }
        $sharedFiles['upload/library/Waindigo/' . $sharedFile . '.php'] = $filePath . '/' . $sharedFile . '.php';
        $sharedFiles['upload/library/Waindigo/' . $sharedFile . '/' . $version . '.php'] = $filePath . '/' . $sharedFile .
             '/' . $version . '.php';
        return $sharedFiles;
    } /* END _getSharedFile */

    protected static function _isFilesIdentical($fn1, $fn2)
    {
        if (filetype($fn1) !== filetype($fn2))
            return false;

        if (filesize($fn1) !== filesize($fn2))
            return false;

        if (!$fp1 = fopen($fn1, 'rb'))
            return false;

        if (!$fp2 = fopen($fn2, 'rb')) {
            fclose($fp1);
            return false;
        }

        while (!feof($fp1) and !feof($fp2))
            if (fread($fp1, 4096) !== fread($fp2, 4096)) {
                return false;
            }

        if (feof($fp1) !== feof($fp2)) {
            return false;
        }

        fclose($fp1);
        fclose($fp2);

        return true;
    } /* END _isFilesIdentical */

    public function addCopyrightNotice(array $addOn)
    {
        if (XenForo_Application::$versionId >= 1020000) {
            $key = $this->_getCopyrightModificationKey($addOn);

            if (!$key) {
                return;
            }

            /* @var $templateModificationModel XenForo_Model_TemplateModification */
            $templateModificationModel = XenForo_Model::create('XenForo_Model_TemplateModification');

            $templateModification = $templateModificationModel->getModificationByKey($key);

            /* @var $dw XenForo_DataWriter_TemplateModification */
            $dw = XenForo_DataWriter::create('XenForo_DataWriter_TemplateModification');
            if ($templateModification) {
                $dw->setExistingData($templateModification);
            }
            $dw->bulkSet(
                array(
                    'template' => 'footer',
                    'modification_key' => $key,
                    'description' => 'Copyright notice for ' . $addOn['title'],
                    'action' => 'callback',
                    'find' => '/{xen:phrase (?:xenforo|extra)_copyright}/',
                    'replace' => 'Waindigo_Listener_InitDependencies::copyrightNotice',
                    'execution_order' => 1,
                    'enabled' => 1,
                    'addon_id' => $addOn['addon_id']
                ));
            $dw->save();
        }
    } /* END addCopyrightNotice */

    protected function _getCopyrightModificationKey(array $addOn)
    {
        $addOnParts = explode('_', $addOn['addon_id'], 2);
        if ($addOnParts[0] != 'Waindigo') {
            return;
        }

        return 'waindigo_copyrightNotice_' . lcfirst($addOnParts[1]);
    } /* END _getCopyrightModificationKey */

    public function makeCompatibilitySwitches(SimpleXMLElement $addOnXML)
    {
        foreach ($addOnXML->code_event_listeners->listener as $listener) {
            /* @var $listener SimpleXMLElement */
            if ($listener['event_id'] == 'load_class' && $listener['active']) {
                $listener['active'] = 0;
                $listener['compatibility_switch'] = 1;
            } elseif ((strpos($listener['event_id'], 'load_class_') === 0 ||
                 strpos($listener['event_id'], 'template_') === 0) && $listener['active'] == 0) {
                $listener['active'] = 1;
                $listener['compatibility_switch'] = 1;
            }
        }
    } /* END makeCompatibilitySwitches */
}

if (false === function_exists('lcfirst')) {

    /**
     * Make a string's first character lowercase
     *
     * @param string $str
     * @return string the resulting string.
     */
    function lcfirst($str)
    {
        $str[0] = strtolower($str[0]);
        return (string) $str;
    }
}