<?php

class Waindigo_InstallUpgrade_Helper_File
{

    public static function processFiles(array $filenames)
    {
        $allFilenames = $filenames;
        foreach ($filenames as $filename) {
            if (is_dir($filename)) {
                self::_addFilesInDirectory($filename, $allFilenames);
            }
        }

        foreach ($allFilenames as $filename) {
            $ext = pathinfo($filename, PATHINFO_EXTENSION);

            if ($ext != 'php') {
                continue;
            }

            $data = file_get_contents($filename);

            $pattern = '#(?:\t|    )(?:public|private|protected)(?: static)?(?: final)? function ([a-zA-Z_]*)\(.*} /\* END ([a-zA-Z_]*::)?\g{-2}#Us';

            preg_match_all($pattern, $data, $skipMatches);

            $skipFunctions = array();
            if ($skipMatches[1]) {
                $skipFunctions = $skipMatches[1];
            }

            $pattern = '#(?:\t|    )(?:public|private|protected)(?: static)?(?: final)? function ([a-zA-Z_]*)\(.*\n(?:\t|    )}#Us';

            preg_match_all($pattern, $data, $matches);

            if ($matches[1]) {
                $newData = $data;
                foreach ($matches[1] as $key => $functionName) {
                    if (in_array($functionName, $skipFunctions)) {
                        $search = '# /\* END [a-zA-Z_]*::' . $matches[1][$key] . ' \*/#U';
                        $replace = ' /* END ' . $matches[1][$key] . ' */';
                        $newData = preg_replace($search, $replace, $newData, 1);
                        unset($matches[0][$key]);
                        unset($matches[1][$key]);
                    }
                }

                if ($matches[0]) {
                    foreach ($matches[0] as $key => $search) {
                        $replace = $search . ' /* END ' . $matches[1][$key] . ' */';
                        $newData = str_replace($search, $replace, $newData);
                    }
                }

                if ($newData != $data) {
                    file_put_contents($filename, $newData);
                }
            }
        }
    } /* END processFiles */

    protected static function _addFilesInDirectory($filename, array &$filenames)
    {
        $handle = opendir($filename);
        if ($handle) {
            while (false !== ($file = readdir($handle))) {
                if ((substr($file, 0, 1) != ".")) {
                    $filenames[] = $filename . '/' . $file;
                    if (is_dir($filename . '/' . $file)) {
                        self::_addFilesInDirectory($filename . '/' . $file, $filenames);
                    }
                }
            }
            closedir($handle);
        }
    } /* END _addFilesInDirectory */

    public static function processJsFiles($filename)
    {
        $handle = opendir($filename);
        if ($handle) {
            while (false !== ($file = readdir($handle))) {
                if ((substr($file, 0, 1) != ".")) {
                    if (pathinfo($file, PATHINFO_EXTENSION) == 'js') {
                        $jsCode = '';
                        if (file_exists($filename . '/full/' . $file)) {
                            $jsCode = file_get_contents($filename . '/full/' . $file);
                            $destination = $filename . '/' . $file;
                        } elseif (pathinfo($filename, PATHINFO_FILENAME) == 'full' && !file_exists(pathinfo($filename, PATHINFO_BASENAME) . $file)) {
                            $jsCode = file_get_contents($filename . '/' . $file);
                            $destination = pathinfo($filename, PATHINFO_DIRNAME) . '/' . $file;
                        }
                        if ($jsCode) {
                            try {
                                $compiler = XenForo_Helper_Http::getClient('http://closure-compiler.appspot.com/compile');

                                $compiler->setParameterPost('js_code', $jsCode);
                                $compiler->setParameterPost('output_info', 'compiled_code');
                                $compilerResponse = $compiler->request('POST');

                                if ($compiler && $compilerResponse->getStatus() == 200) {
                                    file_put_contents($destination, $compilerResponse->getBody());
                                }
                            } catch (Zend_Http_Client_Exception $e) {
                                file_put_contents($destination, $jsCode);
                            }
                        }
                    }
                    if (is_dir($filename . '/' . $file)) {
                        self::processJsFiles($filename . '/' . $file);
                    }
                }
            }
            closedir($handle);
        }
        if (!file_exists($filename . '/index.html')) {
            file_put_contents($filename . '/index.html', '');
        }
    } /* END processJsFiles */
}