<?php

/**
 * Provides an interface for iterating recursively over filesystem directories.
 *
 * Manually skips '.' and '..' directories, since no existing method is
 * available in PHP 5.2.
 *
 * @todo Depreciate in favor of RecursiveDirectoryIterator::SKIP_DOTS once PHP
 * 5.3 or later is required.
 */
class Waindigo_InstallUpgrade_Helper_SkipDotsRecursiveDirectoryIterator extends RecursiveDirectoryIterator
{

    /**
     * Constructs a SkipDotsRecursiveDirectoryIterator
     *
     * @param $path The path of the directory to be iterated over.
     */
    function __construct($path)
    {
        parent::__construct($path);
    }

    function rewind()
    {
        parent::rewind();
        while ($this->isDot()) {
            parent::next();
        }
    }

    function next()
    {
        parent::next();
        while ($this->isDot()) {
            parent::next();
        }
    }
}