<?php

class Waindigo_InstallUpgrade_Listener_TemplateHook extends Waindigo_Listener_TemplateHook
{

    protected static $_firstRun = true;

    protected static $_visibleCopyrightNotice = false;

    public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
    {
        if (self::$_firstRun) {
            self::$_visibleCopyrightNotice = self::$_copyrightNotice;
            if (XenForo_Application::$versionId >= 1020000) {
                self::$_copyrightNotice = true;
            }

            $xenOptions = XenForo_Application::get('options');

            if (!$xenOptions->waindigo_installUpgrade_showCopyrightRobots || !XenForo_Visitor::getInstance()->get('is_robot')) {
                if ($xenOptions->waindigo_installUpgrade_copyrightVisibility == 'js') {
                    $template->addRequiredExternal('js', 'js/waindigo/installupgrade/hide_copyright.js');
                } elseif ($xenOptions->waindigo_installUpgrade_copyrightVisibility == 'css') {
                    $template->addRequiredExternal('css', 'waindigo_hide_copyright_installupgrade');
                }
            }

            self::$_firstRun = false;
        }

        $templateHook = new Waindigo_InstallUpgrade_Listener_TemplateHook($hookName, $contents, $hookParams, $template);
        $contents = $templateHook->run();
    } /* END templateHook */

    public static function getVisibleCopyrightNotice()
    {
        return self::$_visibleCopyrightNotice;
    } /* END getVisibleCopyrightNotice */
}