<?php

class Waindigo_InstallUpgrade_Model_ZipArchive extends ZipArchive
{

    /* creates a compressed zip file */
    public static function createZipWithFiles($files = array(), $destination = '', $overwrite = false)
    {
        $mostRecentUpdate = 0;

        //if the zip file already exists and overwrite is false, return false
        if (file_exists($destination) && !$overwrite) {
            return false;
        }
        //vars
        $valid_files = array();
        //if files were passed in...
        if (isset($files['file'])) {
            //cycle through each file
            foreach ($files['file'] as $localname => $filename) {
                //make sure the file exists
                if (file_exists($filename)) {
                    $valid_files[$localname] = $filename;
                }
            }
        }
        $valid_file_strings = array();
        if (isset($files['fromString'])) {
            $valid_file_strings = $files['fromString'];
        }
        //if we have good files...
        if (count($valid_files)) {
            //create the archive
            $zip = new Waindigo_InstallUpgrade_Model_ZipArchive();
            if ($zip->open($destination, $overwrite ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) !== true) {
                return false;
            }
            //add the files
            foreach ($valid_files as $localname => $filename) {
                if (is_dir($filename)) {
                    $modified = $zip->addDirectory($filename, $localname);
                } else {
                    $zip->addFile($filename, $localname);
                    $modified = filemtime($filename);
                }
                if ($modified > $mostRecentUpdate)
                    $mostRecentUpdate = $modified;
            }
            foreach ($valid_file_strings as $filename => $string) {
                $zip->addFromString($filename, $string);
            }

            //close the zip -- done!
            $zip->close();

            //check to make sure the file exists
            return $mostRecentUpdate;
        } else {
            return false;
        }
    } /* END createZipWithFiles */

    public function addDirectory($dirName, $localName)
    {
        $mostRecentUpdate = 0;
        // adds directory
        $dir = dir($dirName);
        while ($entry = $dir->read()) {
            if ($entry[0] != ".") {
                if (is_dir($dirName . "/" . $entry)) {
                    $modified = $this->addDirectory($dirName . "/" . $entry, $localName . "/" . $entry);
                } else {
                    $this->addFile($dirName . "/" . $entry, $localName . "/" . $entry);
                    $modified = filemtime($dirName . "/" . $entry);
                }
                if ($modified > $mostRecentUpdate)
                    $mostRecentUpdate = $modified;
            }
        }
        return $mostRecentUpdate;
    } /* END addDirectory */
}