<?php

abstract class Waindigo_Listener_ContainerParams
{

    protected $_params = null;

    /**
     *
     * @var XenForo_Dependencies_Abstract
     */
    protected $_dependencies = null;

    /**
     *
     * @param array $params
     * @param XenForo_Dependencies_Abstract $dependencies
     */
    public function __construct(array &$params, XenForo_Dependencies_Abstract $dependencies)
    {
        $this->_params = $params;
        $this->_dependencies = $dependencies;
    } /* END __construct */

    /**
     * This only works on PHP 5.3+, so method should be overridden for now.
     */
    public static function containerPublicParams(array &$params, XenForo_Dependencies_Abstract $dependencies)
    {
        if (function_exists('get_called_class')) {
            $className = get_called_class();
        } else {
            $className = get_class();
        }

        $params = self::createAndRun($className, $params, $dependencies);
    } /* END containerPublicParams */

    /**
     * This only works on PHP 5.3+, so method should be overridden for now.
     */
    public static function containerAdminParams(array &$params, XenForo_Dependencies_Abstract $dependencies)
    {
        if (function_exists('get_called_class')) {
            $className = get_called_class();
        } else {
            $className = get_class();
        }

        $params = self::createAndRun($className, $params, $dependencies);
    } /* END containerAdminParams */

    /**
     *
     * @return array
     */
    public function run()
    {
        return $this->_params;
    } /* END run */

    /**
     *
     * @return array
     */
    protected function _run()
    {
        if (XenForo_Application::debugMode()) {
            return $this->run();
        }
        try {
            return $this->run();
        } catch (Exception $e) {
            return $this->_params;
        }
    } /* END _run */

    /**
     * Factory method to get the named container params listener.
     * The class must exist or be autoloadable or an exception will be thrown.
     *
     * @param string Class to load
     *
     * @return Waindigo_Listener_ContainerPublicParams
     */
    public static function create($class, array &$params, XenForo_Dependencies_Abstract $dependencies)
    {
        $createClass = XenForo_Application::resolveDynamicClass($class, 'listener_waindigo');
        if (!$createClass) {
            throw new XenForo_Exception("Invalid listener '$class' specified");
        }

        return new $createClass($params, $dependencies);
    } /* END create */

    /**
     *
     * @return array
     */
    public static function createAndRun($class, array &$params, XenForo_Dependencies_Abstract $dependencies)
    {
        $class = self::create($class, $params, $dependencies);

        return $class->_run();
    } /* END createAndRun */

    /**
     *
     * @param string $param
     * @param mixed $value
     */
    public function setParam($param, $value)
    {
        $this->_params[$param] = $value;
    } /* END setParam */

    /**
     *
     * @param string $param
     * @return mixed
     */
    public function getParam($param)
    {
        if (!isset($this->_params[$param])) {
            return null;
        }

        return $this->_params[$param];
    } /* END getParam */
}