<?php

abstract class Waindigo_Listener_TemplateHook extends Waindigo_Listener_Template
{
	protected $_hookName = null;
	protected $_hookParams = null;
	protected $_viewParams = null;

	public function run()
	{
		switch ($this->_hookName)
		{
			case 'page_container_breadcrumb_bottom':
				if (!self::$_copyrightNotice) $this->_copyrightNotice();
				break;
		}
		return parent::run();
	}
	
	public function __construct($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template) {
		$this->_hookName = $hookName;
		$this->_hookParams = $hookParams;
		parent::__construct($contents, $template);
	}
	
	// This only works on PHP 5.3+, so method should be overridden for now
	public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
		$class = get_called_class();
		$templateHook = new $class($hookName, $contents, $hookParams, $template);
		$contents = $templateHook->run();
	}

	protected function _fetchViewParams()
	{
		if (!$this->_viewParams)
		{
			$this->_viewParams = array_merge($this->_template->getParams(), $this->_hookParams);
		}
		return $this->_viewParams;
	}
	
	protected final function _copyrightNotice()
	{
		$this->_prepend(self::$copyrightNotice);
		self::$_copyrightNotice = true;
	}
}