<?php

class Waindigo_LoginAsUser_Extend_XenForo_ControllerPublic_Error extends XFCP_Waindigo_LoginAsUser_Extend_XenForo_ControllerPublic_Error
{

    /**
     *
     * @see XenForo_ControllerPublic_Error::actionNoPermission()
     */
    public function actionNoPermission()
    {
        if (XenForo_Visitor::getUserId() && XenForo_Application::get('options')->waindigo_loginAsUser_loginNoPermission) {
            $viewParams = array(
                'text' => new XenForo_Phrase('do_not_have_permission'),
                'visitor' => array(
                    'user_id' => ''
                ),
                'xenOptions' => array(
                    'registrationSetup' => array(
                        'enabled' => false
                    )
                )
            );

            $viewingUser = XenForo_Visitor::getInstance()->toArray();
            if ($viewingUser['user_id'] &&
                 XenForo_Permission::hasPermission($viewingUser['permissions'], 'general', 'loginAsDifferentUser')) {
                /* @var $userModel XenForo_Model_User */
                $userModel = XenForo_Model::create('XenForo_Model_User');

                $users = array();

                $xenOptions = XenForo_Application::get('options');

                if (!$xenOptions->waindigo_loginAsUser_useComboBox) {
                    if ($userModel->canLoginAsUsers()) {
                        $userGroupIds = array_keys(XenForo_Application::get('options')->waindigo_loginAsUser_userGroups);

                        if (!empty($userGroupIds)) {
                            $users = $userModel->getUsersByUserGroupIds($userGroupIds);
                            unset($users[XenForo_Visitor::getUserId()]);
                        }
                    }
                }

                $viewParams['useAutoCombo'] = Waindigo_Listener_ControllerPreDispatch::isAddOnEnabled(
                    'Waindigo_AutoCombo', 'load_class_controller');
                $viewParams['users'] = $users;

                $view = $this->responseView('XenForo_ViewPublic_Error_RegistrationRequired',
                    'waindigo_error_with_login_loginasuser', $viewParams);
            } else {
                $view = $this->responseView('XenForo_ViewPublic_Error_RegistrationRequired', 'error_with_login',
                    $viewParams);
            }
            $view->responseCode = 403;

            return $view;
        }
        return parent::actionNoPermission();
    } /* END actionNoPermission */
}