<?php

class Waindigo_LoginAsUser_Listener_TemplateHook extends Waindigo_Listener_TemplateHook
{

    protected function _getHooks()
    {
        return array(
            'body',
            'moderator_bar',
            'member_card_links',
            'navigation_visitor_tabs_start'
        );
    } /* END _getHooks */

    public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
    {
        $templateHook = new Waindigo_LoginAsUser_Listener_TemplateHook($hookName, $contents, $hookParams, $template);
        $contents = $templateHook->run();
    } /* END templateHook */

    protected function _body()
    {
        /* @var $userModel XenForo_Model_User */
        $userModel = XenForo_Model::create('XenForo_Model_User');

        $viewParams = $this->_fetchViewParams();

        $xenOptions = XenForo_Application::get('options');

        /* @var $session XenForo_Session */
        $session = XenForo_Application::get('session');
        if (($session->isRegistered('loggedInAs') &&
             ($xenOptions->waindigo_loginAsUser_positionLoggedInAs == 'left_moderator_bar' || !XenForo_Visitor::getUserId())) ||
             ($userModel->canLoginAsUsers() && $xenOptions->waindigo_loginAsUser_position == 'left_moderator_bar')) {
            if (!XenForo_Visitor::getInstance()->is_admin && !XenForo_Visitor::getInstance()->is_moderator) {
                if ($session->isRegistered('loggedInAs')) {
                    $viewParams['parentVisitor'] = Waindigo_LoginAsUser_Visitor::getParentInstance()->toArray();
                }
                $viewParams['hideLoginBar'] = true;
                $this->_prependTemplate('waindigo_moderator_bar_loginasuser', $viewParams);
            }
        }
    } /* END _body */

    protected function _moderatorBar()
    {
        /* @var $userModel XenForo_Model_User */
        $userModel = XenForo_Model::create('XenForo_Model_User');

        $viewParams = $this->_fetchViewParams();

        $xenOptions = XenForo_Application::get('options');

        /* @var $session XenForo_Session */
        $session = XenForo_Application::get('session');
        if (($session->isRegistered('loggedInAs') &&
             $xenOptions->waindigo_loginAsUser_positionLoggedInAs == 'left_moderator_bar') ||
             ($userModel->canLoginAsUsers() && $xenOptions->waindigo_loginAsUser_position == 'left_moderator_bar')) {
            if (XenForo_Visitor::getInstance()->is_admin || XenForo_Visitor::getInstance()->is_moderator) {
                if ($session->isRegistered('loggedInAs')) {
                    $viewParams['parentVisitor'] = Waindigo_LoginAsUser_Visitor::getParentInstance()->toArray();
                }
                $this->_appendTemplate('waindigo_you_are_using_as_user_loginasuser', $viewParams);
            }
        }
    } /* END _moderatorBar */

    protected function _memberCardLinks()
    {
        $viewParams = $this->_fetchViewParams();

        $xenOptions = XenForo_Application::get('options');

        if ($viewParams['user']['user_id'] != XenForo_Visitor::getUserId() &&
             $xenOptions->waindigo_loginAsUser_memberCardLink) {
            /* @var $userModel XenForo_Model_User */
            $userModel = XenForo_Model::create('XenForo_Model_User');

            if ($userModel->canLoginAsUser($viewParams['user'])) {
                $this->_appendTemplate('waindigo_member_card_link_loginasuser');
            }
        }
    } /* END _memberCardLinks */

    protected function _navigationVisitorTabsStart()
    {
        /* @var $userModel XenForo_Model_User */
        $userModel = XenForo_Model::create('XenForo_Model_User');

        $viewParams = $this->_fetchViewParams();

        $xenOptions = XenForo_Application::get('options');

        /* @var $session XenForo_Session */
        $session = XenForo_Application::get('session');
        if (($session->isRegistered('loggedInAs') &&
             $xenOptions->waindigo_loginAsUser_positionLoggedInAs == 'left_visitor_tabs') ||
             ($userModel->canLoginAsUsers() && $xenOptions->waindigo_loginAsUser_position == 'left_visitor_tabs')) {
            if ($session->isRegistered('loggedInAs')) {
                $viewParams['parentVisitor'] = Waindigo_LoginAsUser_Visitor::getParentInstance()->toArray();
            }
            $this->_appendTemplate('waindigo_navigation_visitor_tabs_loginasuser', $viewParams);
        }
    } /* END _navigationVisitorTabsStart */
}