<?php

class Waindigo_LoginAsUser_Listener_VisitorSetup
{

    protected static $_runOnce = false;

    public static function visitorSetup(XenForo_Visitor $visitor)
    {
        if ($visitor->user_id && !self::$_runOnce) {
            self::$_runOnce = true;
            if (get_class($visitor) == 'XenForo_Visitor') {
                if (XenForo_Application::isRegistered('session')) {
                    /* @var $session XenForo_Session */
                    $session = XenForo_Application::get('session');
                    if ($session->isRegistered('loggedInAs')) {
                        if ($visitor->user_id != $session->get('loggedInAs')) {
                            return Waindigo_LoginAsUser_Visitor::setup($session->get('loggedInAs'));
                        }
                    }
                }
            }
        }
        return $visitor;
    } /* END visitorSetup */
}