<?php

class Waindigo_PhpFile_Constant
{
    protected $_constantName;
    protected $_phpDoc = array();
    protected $_value = array();

    public function __construct($constantName)
    {
        $this->_constantName = $constantName;
    } /* END __construct */

    public function getConstantName()
    {
        return $this->_constantName;
    } /* END getConstantName */

    public function getValue()
    {
        return $this->_value;
    } /* END getValue */

    public function hasValue()
    {
        return !empty($this->_value);
    } /* END hasValue */

    public function setValue($value)
    {
        $this->_value = $value;
    } /* END setValue */

    public function getPhpDoc()
    {
        return $this->_phpDoc;
    } /* END getPhpDoc */

    public function getPhpDocAsString()
    {
        $contents = '';
        if (!empty($this->_phpDoc))
        {
            $contents.= "\n    /**";
            foreach ($this->_phpDoc as $phpDoc)
            {
                $contents.= rtrim("\n     * $phpDoc");
            }
            $contents.= "\n     */";
        }
        return $contents;
    } /* END getPhpDocAsString */

    public function hasPhpDoc()
    {
        return !empty($this->_phpDoc);
    } /* END hasPhpDoc */

    public function setPhpDoc($phpDoc)
    {
        if (is_array($phpDoc))
        {
            $this->_phpDoc = $phpDoc;
        }
        else
        {
            $this->_phpDoc = array($phpDoc);
        }
    } /* END setPhpDoc */
}